/**
 * @author Vishal Joshi
 */
Ext.define('Academia.view.committee.committee.CommitteeMembershipGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.committeeMembershipGrid',
	store: 'committee.committee.CommitteeMambershipStore',
	title: getCommonTranslation("LIST_OF_MEMBERSHIPS"),
	border: true,
	autoScroll: false,
	frame:false,
	refreshStoreData:true,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'committee.committee.CommitteeMambershipStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {

		var grid=this;                   

		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		disabled:true,
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		disabled:true,
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		disabled:true,
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header:  getCommonTranslation("MEMBERSHIP_TYPE"),
		dataIndex: 'membershiptype',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("MEMBERSHIP_VALID_FROM"),
		dataIndex: 'memberShipStartDate',
		flex:.1,
		sortable:true,
		renderer:function(val){		
			return dateRender(val);
		}
	},{
		header:  getCommonTranslation("MEMBERSHIP_VALID_TILL"),
		dataIndex: 'memberShipEndDate',
		flex:.1,
		sortable:true,
		renderer:function(val){		
			return dateRender(val);
		}
	},{
		header:  getCommonTranslation("MEMBERSHIP_APPLICATION_START_DATE"),
		dataIndex: 'applicationStartDate',
		flex:.1,
		sortable:true,
		renderer:function(val){		
			return dateRender(val);
		}
	},{
		header:  getCommonTranslation("MEMBERSHIP_APPLICATION_END_DATE"),
		dataIndex: 'applicationEndDate',
		flex:.1,
		sortable:true,
		renderer:function(val){		
			return dateRender(val);
		}
	},{
		header:  getServiceRequestTranslation('FEE_APPLICABLE'),
		dataIndex: 'isFeeApplicable',
		flex:.1,
		sortable:true,
		renderer:function(val){
			return val ? 'Yes':'No'
		}
	},{
		header:  getFeeAndPaymentCommonTranslation("FEE_PLAN"),
		dataIndex: 'feePlan',
		flex:.1,
		sortable:true
	},{
		header:  getFeeAndPaymentCommonTranslation('FEE_RULE'),
		dataIndex: 'feePlanRule',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("APPROVER"),
		dataIndex: 'user',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation("AUTO_APPROVE"),
		dataIndex: 'isAutoApprove',
		flex:.1,
		sortable:true,
		renderer:function(val){
			return val ? 'Yes':'No'
		}
	}]
});