Ext.define('Academia.view.course.CourseDocumentList', {
	extend: 'Ext.window.Window',
	alias : 'widget.coursedocumentlist',
	border: true,
	modal : true,
	title: getProgramandcourseTranslation('DOWNLOAD_DOCUMENT'),
	autoScroll: true,
	maxHeight: '20%',
	width: '40%',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	items:[{
		xtype: 'form',
		plugins:"formlabelrequired",
		items: [{
			xtype: 'grid',
			itemId:'coursedocumentlistId',
			border:true,
			store :'course.CourseDocument',
			tbar: [{
				xtype : 'button',				
				itemId : 'btnDelete',
				cls: 'CustomToolbarBtnReject',
				tooltip :getCommonTranslation('DELETE'),
				iconCls: 'icon-Delete',
				cls:'iconDelete'		
			}],
			columns :[{
				header : getCommonTranslation('DOCMENT_NAME'),
				dataIndex : 'documentName',
				flex:1,
				renderer:function(value,rec){
					var id=rec.record.data.id;
					if(id!=""&&id!=undefined){
						return '<a href="#">'+value+'</a>';
					}else{
						return value;
					}
				}
			}]
		}]
	}]
});