/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.course.courseComponent.CourseComponentForm', {
	extend: 'Ext.window.Window',
	alias: 'widget.coursecomponentform',
	modal: true,
	resizable:true,
	autoScroll:true,
	title: getCommonTranslation('COURSE_COMPONENTS'),
	items: [{
		xtype: 'idgeneratorcustomformwin',
		customFieldEntity:CONSTANTS.COURSE_COMPONENT_CUSTOM_FIELD,
		itemId: 'courseComponentFormWindow',
		method: 'POST',
		margin: 0,         
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			flex: 1
		},
		plugins : "formlabelrequired",	
		standardSubmit: false,
		items: [{
			xtype:'hidden',
			name:'id'
		},
		{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width : 226
			},
			items:[{
				xtype: 'customcombobox',
				name: 'componentName',
				fieldLabel: getCommonTranslation('COURSE_COMPONENT'),  
				store:'course.coursecomponent.CourseComponentCombo',
				valueField:'id',
				displayField:'value',
				itemId: 'componentName',
				allowBlank:false
			},
			{
				xtype: 'textfield',
				name: 'componentNameToBePrinted',
				itemId:'componentNameToBePrintedId',
				fieldLabel: getCommonTranslation('COMPONENT_NAME_TO_BE_PRINTED'),  
				allowBlank:false,
				maxLength:255
			},
			]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width : 226
			},
			items:[{
				xtype: 'textfield',
				name: 'componentCode',
				itemId:'componentCodeId',
				readOnly:true,
				fieldLabel: getCommonTranslation('COMPONENT_CODE'),  
				allowBlank:false
			},{
				xtype: 'textfield',
				name: 'componentCourseCodeToBePrinted',
				itemId:'componentCourseCodeToBePrintedId',
				fieldLabel: getCommonTranslation('COMPONENT_CODE_TO_BE_PRINTED'),  
				allowBlank:false,
				maxLength:45
			}
			]
		},
		{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width : 226
			},
			items:[{
				xtype: 'numberfield',
				name: 'componentCutOff',
				itemId: 'componentCutOff',
				fieldLabel: getCommonTranslation('COMPONENT_CUT_OFF'),
				hidden: true
			},{
				xtype: 'numberfield',
				name: 'componentMaxMark',
				itemId: 'componentMaxMark',
				fieldLabel: getCommonTranslation('MAX_MARKS'),
				hidden: true
			}]
		},
		{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width : 226
			},
			items:[{
				xtype: 'customcombobox',
				itemId:'gradeMinCutOff',
				fieldLabel : getCommonTranslation('COURSE_PASS_MIN_CUT_OFF'),
				name:'gradeMinCutOff',
				store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
				displayField: 'gradeName',
				valuefield:'gradeName',
				hidden:true
			},{
				xtype: 'customcombobox',
				itemId:'gradeMaxCutOff',
				fieldLabel : getCommonTranslation('COURSE_PASS_MAX_CUT_OFF'),
				name:'gradeMaxCutOff',
				store:'examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades',
				displayField: 'gradeName',
				valuefield:'gradeName',
				hidden:true
			}]
		},
		{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width : 226
			},
			items:[{
				xtype      : 'fieldcontainer',
				defaultType: 'radiofield',
				itemId : 'whetherComponentExemption',
				defaults: {flex: 1},
				hidden: true,
				layout: 'hbox',
				fieldLabel: getCommonTranslation('COMPONENT_EXEMPTED'),
				name: 'componentExempt',
				items:[
				       { boxLabel:getCommonTranslation('YES'), name: 'whetherComponentExemption', inputValue: 1},
				       { boxLabel:getCommonTranslation('NO'), name: 'whetherComponentExemption', inputValue: 0, checked : true}
				]
			},{
				xtype      : 'fieldcontainer',
				fieldLabel : getCommonTranslation('COMPONENT_ACTIVE'),
				defaultType: 'radiofield',
				itemId : 'componentStatus',
				defaults: {
					flex: 1
				},
				layout: 'hbox',
				items: [{
					boxLabel  : getCommonTranslation('YES'),
					name      : 'componentStatus',
					inputValue: true,
					checked : true
				}, {
					boxLabel  : getCommonTranslation('NO'),
					name      : 'componentStatus',
					inputValue: false		                     
				}]
			}]
		},
		{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width : 226
			},
			items:[{
				xtype: 'numberfield',
				name: 'componentCredit',
				fieldLabel: getCommonTranslation('CREDITS'),
//				allowBlank:false,
				allowExponential:false,
				minValue:0,
				allowDecimals:true,
				hideTrigger:true,
				decimalPrecision: 2
			},{
				xtype: 'numberfield',
				name: 'weighting',
				itemId: 'weightingId',
				fieldLabel: getExaminationTranslation('WEIGHTING'),
//				allowBlank:false,
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width : 226
			},
			items:[{
				xtype: 'numberfield',
				name: 'courseComponentHours',
				itemId:'courseComponentHoursId',
				fieldLabel: getCommonTranslation('COURSE_COMPONENT_HOURS'),
				allowBlank:true,
				allowExponential:false,
				minValue:0,
				allowDecimals:true,
				hideTrigger:true,
				hidden: true,
				decimalPrecision: 2
			}]
		},
		{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width : 462
			},
			items:[{
		        xtype: 'textareafield',
		        name: 'componentDesc',
		        itemId: 'componentDesc',
		        allowBlank:false,
		        fieldLabel: getCommonTranslation('DESCRIPTION')
		      }]
		},{
			layout: {
				type: 'hbox'
			},
			style:{
				marginLeft:'0px'
			},
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'courseComponentSaveBtnId',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'courseComponentCancelBtnId',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE            
			}]
		}]
	}]
});