/**
 * @author seshagiri.k
 */
Ext.define('Academia.view.course.coursegroup.history.ViewRelatedProgramsGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.viewRelatedProgramsGrid',
    store: 'course.coursegroup.ViewRelatedProgramStore',
    border: true,
    autoScroll: true,
    viewConfig: {
        stripeRows: true
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'pagingtoolbar',
            store: 'course.coursegroup.ViewRelatedProgramStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    columns: [{
        header: getCommonTranslation('PROGRAM_NAME'),
        dataIndex: 'programName',
        sortable:true,
        flex: .1
    }, {
        header: getCommonTranslation('BATCH_YEAR'),
        dataIndex: 'batch',
        sortable: true,
        flex: .1
    }, {
        header: getCommonTranslation('PRIMARY_ACADEMIC_YEAR'),
        dataIndex: 'primaryAcademicYear',
        sortable:true,
        flex: .1
    }, {
        header: getCommonTranslation('ENROLL_REQ_RECEIVED'),
        dataIndex: 'EnrollReqReceived',
        sortable:true,
        flex: .1
    }, {
        header: getCommonTranslation('ENROLL_REQ_REJECTED'),
        dataIndex: 'EnrollReqRejected',
        sortable:true,
        flex: .1
    }, {
        header: getCommonTranslation('STUDENT_ENROLLED'),
        dataIndex: 'studentEnrolled',
        sortable:true,
        flex: .1
    }, {
        header: getCommonTranslation('STUDENT_PASSED'),
        dataIndex: 'studentPassed',
        sortable:true,
        flex: .1
    }]
});