/**
 * @author Deepak S
 */
Ext.define('Academia.view.course.readingmaterial.readingmaterialinformation.MapLinkedCoursesDetailPncGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.maplinkedcoursesdetailpncgrid',
    store: Ext.create('Academia.store.course.readingmaterial.PncMapCoursesStore'),
    title: getCourseTxCommonTranslation('COURSE_READING'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        //markDirty : false,
        deferEmptyText: false,
        emptyText: getCommonTranslation('NORESULTSNMESSAGE')
    },
    tbar: [{	
		xtype:'fieldcontainer',
		layout : 'hbox',
		cls:'windowBtnPos',
		itemId: 'fldContSaveItemId',
		defaults: {
			labelAlign:'top',
		},
		items:[{
			xtype: 'button',
			itemId: 'btnSaveMapLinkedCourseItemId',
			tooltip: getExaminationTranslation('SAVE'),
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			text:getExaminationTranslation('SAVE'),
			//formBind : true
		}]
	}],
    columns: [{
		header :getCommonTranslation('COURSE_DEPARTMENT'),
		dataIndex : 'courseDepartmentName',
		flex:1
	},{
        header: getCommonTranslation('COURSE_CODE_NAME'),
        dataIndex: 'courseName',
        flex: 1,
        sortable: true
    },{
        header: getServiceRequestTranslation('STATUS'),
        dataIndex: 'status',
        flex: 0.5,
        sortable: true,
        editor: {
            xtype: 'customcombobox',
            name: 'status',
            itemId: 'statusItemId',
            valueField: 'id',
            displayField: 'name',
            forceSelection: true,
            editable: false,
            listeners: {
            	focus: function(combo, eOpt) {
            		if (combo.getRawValue() == "")
            			combo.setRawValue(getCommonTranslation("ACTIVE"));
            		else
            			combo.setRawValue(getCommonTranslation(combo.getValue()));
            	},
            	blur: function(combo, r) {
            		combo.setValue(combo.getValue());
            	},
            	render: function(combo) {
            		var store = Ext.create('Academia.store.common.StatusComboStore');
            		combo.bindStore(store);
            	},
            	change: function(combo, eOpt) {
            		combo.setRawValue(getCommonTranslation(combo.getValue()));
            	}
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            var grid = view.up();
            if (isNullOrEmpty(val) && isNullOrEmpty(record.data.status)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                var store = grid.getStore();
                var models = grid.getStore().getRange();
                /*if (!isNullOrEmpty(val)) {
                    if (record.data.status == 'PENDING') {
                        if (val == 'COMPLETED') {
                        	
                        } else {
                            models[rowIndex].set("completionDate", '');
                        }
                    }
                } else if (!isNullOrEmpty(record.data.status)) {
                    val = record.data.status;
                    models[rowIndex].set("status", val);
                }*/
                var colorValue = '';
                if (val == 'ACTIVE') {
                	colorValue = "<span style = 'color:#009e0f;'>" + getCommonTranslation(val) + "</span>";
                } else if (val == 'INACTIVE') {
                	colorValue = "<span style = 'color:#cc0000;'>" + getCommonTranslation(val) + "</span>";
                    
                } 
                return colorValue;
            }
        }
    },{
		header : getCommonTranslation('PRESCRIBED_RECOMMENDED'),
		dataIndex : 'courseReadingPrescribe',
		flex: 1.2,
		sortable: true,
		editor: {
    		xtype: 'customcombobox',
    		name: 'courseReadingPrescribe',
    		itemId: 'courseReadingPrescribeId',
    		store: Ext.create('Academia.store.course.readingmaterial.PncMapCoursesPrescribedRecStore'),
    		valueField: 'id',
            displayField: 'value',
			typeAhead : true,
    		forceSelection: true,
    		editable: false
    	},
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if((!isNullOrEmpty(value))) {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
    				}
        			else{
        				rec.tdCls = 'gridInputCustomStyle';
        				return getExaminationTranslation('CLICK_TO_ENTER');
        			}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(Ext.isDefined(record.get('courseReadingPrescribe')) && !isNullOrEmpty(record.get('courseReadingPrescribe'))){
    				var editor = rec.column.getEditor();
					var models = grid.getStore().getRange();
    				var courseReadingPrescribe = record.get('courseReadingPrescribe');
    				editor.store.load({
						callback:function(){
							if(!isNullOrEmpty(courseReadingPrescribe)){
								models[rowIndex].set("courseReadingPrescribe", courseReadingPrescribe);
							}
						}
    				});
    			}
    			else{
    				rec.tdCls = 'gridInputCustomStyle';
    				return getExaminationTranslation('CLICK_TO_ENTER');
    			}
    		}
    	}
    }/*,{
        header: getCommonTranslation('DATE_REQUIRED'),
        dataIndex: 'dateRequired',
        flex: 0.8,
        sortable: true,
        editor: {
            xtype: 'datefield',
            name: 'dateRequired',
            itemId: 'dateRequiredId',
            listeners: {
                render: function(field) {
                    return dateFormatRender(field);
                }
            }
        },
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
        	var dateVal = dateRender(val);
        	if(dateVal == "NaN-NaN-0NaN"){
        		return val;	
        	}else{
        		return dateRender(val);
        	}
        }
    }*/,{
        header: getCommonTranslation('PHASEOUT_YEAR'),
        dataIndex: 'phaseoutYear',
        flex: 0.8,
        sortable: true,
        editor: {
            xtype: 'numberfield',
            name: 'phaseoutYear',
            itemId: 'phaseoutYearId',
            maxLength: 5,
            minValue:0,
            allowDecimals: false,
            allowExponential:false,
			keyNavEnabled: false,
			hideTrigger: true,
			mouseWheelEnabled:false,
        },
        renderer: function(val, rec) {
            if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
    },{
    	header: getCourseTxCommonTranslation('DISTRIBUTOIN_MODE'),
    	dataIndex: 'distributionModeId',
		flex : 1,
		editor: {
    		xtype: 'customcombobox',
    		name: 'distributionModeId',
    		itemId: 'distributionModeId',
    		store: Ext.create('Academia.store.coursetransaction.coursereading.DistributionMode'),
    		displayField : 'value',
			valueField : 'id',
			typeAhead : true,
    		forceSelection: true,
    		editable: false
    	},
    	listeners: {
    		render: function(combo){
    			combo.getEditor().store.load();
    		}
    	},
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if((!isNullOrEmpty(value))) {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
    				}
    				else{
    					var editor = rec.column.getEditor();
    					var models = store.getRange();
        				var distributionMode = record.get('distributionModeId');
        				editor.store.load({
    						callback:function(){
    							if(!isNullOrEmpty(distributionMode)){
    								models[rowIndex].set("distributionModeId", distributionMode);
    								editor.setValue(distributionMode);
    							}
    						}
        				});
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(Ext.isDefined(record.get('distributionModeId')) && !isNullOrEmpty(record.get('distributionModeId'))){
    				var editor = rec.column.getEditor();
					var models = grid.getStore().getRange();
    				var distributionMode = record.get('distributionModeId');
    				editor.store.load({
						callback:function(){
							if(!isNullOrEmpty(distributionMode)){
								models[rowIndex].set("distributionModeId", distributionMode);
								editor.setValue(distributionMode);
							}
						}
    				});
    			}
    			else{
    				rec.tdCls = 'gridInputCustomStyle';
    				return getExaminationTranslation('CLICK_TO_ENTER');
    			}
    		}
    	}
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        flex: 0.6,
        cls: 'CustomBodyBtnSettings',
        sortable: true,
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
            if (!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) {
                return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
            }
            return '';
        }
    }],
    plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
        	edit: function (editor, context, e) {
        		
        	}
        }
    }]
});