
var CourseReadingMaterialStore = Ext.create('Academia.store.course.readingmaterial.ReadingMaterialGridStr');
Ext.define('Academia.view.course.readingmaterial.readingmaterialinformation.ReadingMaterialGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.readingmaterialgrid',
	store : CourseReadingMaterialStore,
	title: getCommonTranslation('LIST_OF_COURSE_READING_MATERIAL'),
	border: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			store : CourseReadingMaterialStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);     
 },
 isGridConfigurable: true,
 enableColumnHide: false,
	tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        disabled : true
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    },{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    },{
        xtype: 'button',
        itemId:'mapCourseReadingMaterail',
        text: getCourseTxCommonTranslation("MAP_COURSES")
    },{
	    xtype : 'splitbutton',
	    itemId:'spBtnMoreActions',
	    disabled : true,
	    text : getCommonTranslation('MOREACTIONS'),
	    menu:[{
			text: getProgramandcourseTranslation('PC_ADD_READING_STOCK'),
			itemId:'addInventoryItemId',
	    },{
			text: getCommonTranslation("RESOURCE_REQUEST_DETAILS"),
			itemId:'mapCourseVariantReadingMaterail',
	    }],
	    listeners: { click: function() { this.showMenu(); } }
    },{
    	xtype: 'tbspacer',
    	flex:1
    },{
		xtype: 'button',
		text:getCommonTranslation('EXPORT_REPORT'),
		itemId:'exportReport',
		tooltip :getCommonTranslation('EXPORT_REPORT'),
	    disabled : true
	}],
	columns : [{
		header :getCommonTranslation('READING_TYPE'),
		dataIndex : 'readingType',
		flex:1
	},{
		header : getCommonTranslation('READING_NAME'),
		dataIndex : 'readingName',
		flex:1
	},{
		header : getCommonTranslation('PC_FIRST_AUTHOR'),
		dataIndex : 'author',
		flex:1
	},{
		header : getCommonTranslation('SECOND_AUTHOR'),
		dataIndex : 'secondAuthor',
		hidden:true,
		flex:1
	},{
		header : getCommonTranslation('THIRD_AUTHOR'),
		dataIndex : 'thirdAuthor',
		hidden:true,
		flex:1
	},{
		header : getProgramandcourseTranslation('FOURTH_AUTHOR'),
		dataIndex : 'fourthdAuthor',
		hidden:true,
		flex:1
	},{
		header : getProgramandcourseTranslation('FIFTH_AUTHOR'),
		dataIndex : 'fifthAuthor',
		hidden:true,
		flex:1
	},{
		header : getCourseTxCommonTranslation('PUBLISHER'),
		dataIndex : 'publisher',
		flex:1
	},{
		header : getProgramandcourseTranslation('PC_ISBN_10'),
		dataIndex : 'isbnTen',
		flex:1
	},{
		header : getProgramandcourseTranslation('PC_ISBN_13'),
		dataIndex : 'isbnThirteen',
		flex:1
	},{
		header : getCommonTranslation('PC_ISSUE_YEAR'),
		dataIndex : 'issueYear',
		flex:1
	},{
		header : getCourseTxCommonTranslation('VOLUME'),
		dataIndex : 'volume',
		flex:1
	},{
		header : getCommonTranslation('EDITION'),
		dataIndex : 'edition',
		flex:1
	},{
		header : getCommonTranslation('CURRENT_STOCK'),
		dataIndex : 'currentStock',
		flex:1
	},{
		header : getCommonTranslation('BINDING'),
		dataIndex : 'binding',
		flex:1,
		renderer:function(value) {
			return getProgramandcourseTranslation(value);
		}
	},{
		header : getCommonTranslation('LINDKED_COURSES'),
		dataIndex : 'courseId',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return '0';
			}
		}
	}]
});
