/**
 * @author Utsav
 * @author Seshagiri.k
 */
Ext.define('Academia.view.course.reports.CourseReportSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.coursereportsearchform',
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
    layout: 'vbox',
    items: [{
    	plugins : "formlabelrequired",
       /* xtype: 'form',
        width: '100%',
        items: [{*/
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 226,
                labelAlign: 'top'
            },
            items: [{
            	width:460,
            	xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
//                translationKey:'ACADEMY_LOCATION',
                name: 'academyLocationId',
                itemId: 'academyLocationId',
                store:'common.AcademyLocationNameSeparated',
                displayField: 'value',
                valueField: 'id',
                //allowBlank:false,
                minChars:3,
                queryParam:'qry',
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}
            },{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
//                translationKey:'COURSE',
                name: 'courseId',
                itemId: 'courseReportCourseId',
                disabled:true,
                 editable: true,
                typeAhead:false,
				hideTrigger:true,
				forceSelection:true,
                //allowBlank:false,
                store: 'course.CourseComboStore',
                queryParam:'name',
            	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                displayField: 'value',
                valueField: 'id',
                minChars:3,
                width: 226,
                enableKeyEvents  : 'true',
				hideTrigger:false,
                listConfig: {
  				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{code} / {value}'+ 
	                    '</div>';
	                }
	            } 
            }]   
        },{	
    		xtype:'fieldcontainer',
    		width: '100%',
    		 
    		items:[{  
   			 xtype: 'button',
             text: getCommonTranslation('SEARCH'),
             itemId: 'courseReportSearchButtonId',
             buttonAlign: 'left',
             ui: 'CustomBtnSubmit',
             scale: CONSTANTS.BUTTONSIZE,
             formBind : true
	     },{
    			xtype: 'button',
    			itemId: 'resetBtn',
    			text: getCourseTxCommonTranslation('RESET'),
    			ui:'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE
    		}]	
        }]
   // }]
});