/**
 * @author Dharmendra.prajapati
 * 
 */
Ext.require([
    'Ext.ux.form.MultiSelect'
]);

Ext.define('Academia.view.coursetracker.CourseTrackerSearch', {
	extend: 'Ext.form.Panel',
	alias: 'widget.coursetrackersearch',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
	layout: 'vbox',
	method: 'POST',
	plugins : "formlabelrequired",
	standardSubmit: false,
	items: [{
		/*xtype: 'form',
		width: '100%',

		items: [{*/
			xtype : 'radiogroup',
			itemId : 'courseSectionTypeRadio',
			items : [{
				boxLabel : getCourseTxCommonTranslation('PROGRAM_BATCH_SECTION'),
//				translationKey:'PROGRAM_BATCH_SECTION',
				name : 'sectionType',
				inputValue : 'PBS',
				checked : true
			},{
				boxLabel : getCourseTxCommonTranslation('COURSE_SECTION'),
//				translationKey:'COURSE_SECTION',
				name : 'sectionType',
				inputValue : 'CBS'
			}]
		},{
			xtype: 'fieldcontainer',
//			width: 'auto',
			layout: 'hbox',
			defaults: {
			width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype : 'combobox',
				fieldLabel: getCommonTranslation('VIEW_STATISTICS'),
				itemId : 'selectionGroupId',
				name : 'multiselectFields',
				store:[getCommonTranslation('COURSE'),'Section','Topic'],
				
				defaults: {
					flex: 1,
					width: 100
				},
				layout: 'hbox',
				
				items : [/*{
					boxLabel : getCommonTranslation('COURSE'),
//					translationKey:'COURSE',
					name : 'multiselectFields',
					inputValue : 'Course',
					hidden:true
				},{
					boxLabel : getCommonTranslation('SECTION'),
					name : 'multiselectFields',
					inputValue : 'Section'
				},{
					boxLabel : getCommonTranslation('TOPIC'),
					name : 'multiselectFields',
					inputValue : 'Topic'
				}*/]
			}
			]}
		,{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			itemId : 'programBatchPeriodContainer',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			hidden : true,
			items: [{
				xtype: 'customcombobox',
				name: 'program',
				itemId : 'programId',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//				translationKey:'PROGRAM',
				store : 'common.ProgramByAcademyLocationStore',
				displayField : 'valueCode',
				valueField : 'id',
				allowBlank: false,
				queryParam:'programName',
				minChars:3,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'batch',
				itemId : 'batchId',
				fieldLabel: getCommonTranslation('BATCH'),
				store : 'enquiry.AcademicBatchStore',
				displayField : 'value',
				valueField : 'id',
				disabled : true,
				allowBlank: false
			},{
				xtype: 'customcombobox',
				name: 'period',
				itemId : 'periodId',
				fieldLabel: getCommonTranslation('PERIOD'),
				store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				displayField : 'value',
				valueField : 'id',
				disabled : true,
				allowBlank: false
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			itemId : 'courseComponentSectionContainer',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'course',
				itemId: 'courseId',
				fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
//				translationKey:'COURSE',
				store:'attendance.StudentCourses',
				displayField:'courseCodeName',
				valueField:'courseId',
				allowBlank: false,
				queryParam:'name',
				minChars:3,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{courseCodeName}'  +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'component',
				itemId: 'componentSectionId',
				fieldLabel: getCommonTranslation('COMPONENT'),
				store:'course.coursetopic.CourseComponentStore',
				displayField:'value',
				valueField:'id',
				hidden : true
			},{
				xtype: 'customcombobox',
				name: 'section',
				itemId: 'courseSection_Id',
				fieldLabel: getCommonTranslation('SECTION'),
				store:'attendance.SectionByCourseNComponent',
				displayField:'sectionCode',
				valueField:'sectionId',
				disabled:true
			},{
				xtype: 'multiselectcombofield',
				width: 460,
				name: 'multiselectSectionCBS',
				itemId: 'multipleCourseSection_Id',
				fieldLabel: getCommonTranslation('SECTION'),
				store:'attendance.SectionByCourseNComponent',
				displayField:'sectionCode',
				valueField:'sectionId',
				hidden:true,
				disabled:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						},
						afterRender: function(combo){
							combo.getStore().on("load", function(store, items){
								if(items.length==0)
									Ext.select('.x-boundlist-item').elements[0].hidden = true;
								else
									Ext.select('.x-boundlist-item').elements[0].hidden = false;
							});
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			itemId : 'courseComponentSectionContainer_1',
			hidden : true,
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'course_1',
				itemId: 'courseId_1',
				fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
//				translationKey:'COURSE',
				store : 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore',
				displayField : 'value',
				valueField : 'id',
				allowBlank: false,
				disabled : true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				minChars:3,
				forceSelection : true,
				queryParam:'name',
				listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{courseCodeName}'  +
		                    '</div>';
		                }
		            }
			},{
				xtype: 'multiselectcombofield',
				width: 460,
				name: 'multiselectCoursePBS',
				itemId: 'multiselectCourseId',
				fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
//				translationKey:'COURSE',
				store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore',
				displayField:'value',
				valueField:'id',
				hidden:true,
				disabled :true,
				forceSelection:true,
				queryParam:'name',
				minChars:3,
				enableKeyEvents  : 'true',
				typeAhead:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						},
						afterRender: function(combo){
							combo.getStore().on("load", function(store, items){
								if(items.length==0)
									Ext.select('.x-boundlist-item').elements[0].hidden = true;
								else
									Ext.select('.x-boundlist-item').elements[0].hidden = false;
							});
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'component_1',
				itemId: 'componentSectionId_1',
				fieldLabel: getCommonTranslation('COMPONENT'),
				store : 'course.coursetopic.CourseComponentStore',
				displayField : 'value',
				valueField : 'id',
				hidden : true
			},{
				xtype: 'customcombobox',
				name: 'section_1',
				itemId: 'courseSection_Id_1',
				fieldLabel: getCommonTranslation('SECTION'),
//				store : 'coursetransaction.facultytopicassignment.CourseSectionByPeriodIDCourseIDStore',
				store :'attendance.SectionAndFacultyByPeriodID',
				displayField : 'sectionCode',
				valueField : 'sectionId',
				disabled:true
			},{
				xtype: 'multiselectcombofield',
				name: 'multiselectSection_1PBS',
				width: 460,
				itemId: 'multiselectSection_Id_1',
				fieldLabel: getCommonTranslation('SECTION'),
//				store : 'coursetransaction.facultytopicassignment.CourseSectionByPeriodIDCourseIDStore',
				store :'attendance.SectionAndFacultyByPeriodID',
				displayField : 'sectionCode',
				valueField : 'sectionId',
				hidden:true
//				disabled:true
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'topics',
				itemId: 'topicsId',
				fieldLabel:getCourseTxCommonTranslation('TOPIC'),
				store : 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.Topic',
				displayField : 'value',
				valueField : 'id',
				disabled:true
			},{
				xtype: 'multiselectcombofield',
				width: 460,
				name: 'multiselectTopics',
				itemId: 'multipleTopicsId',
				fieldLabel:getCourseTxCommonTranslation('TOPIC'),
				store : 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.Topic',
				displayField : 'value',
				valueField : 'id',
//				delimiter: null,
				typeAhead:true,
				forceSelection:true,
				hidden:true
			}
			]},{
				xtype : 'fieldcontainer',
				width: 'auto',
				layout : {
					type : 'hbox'
				},
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				items : [{
					xtype : 'datefield',
					fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
					name : 'fromDate',
					itemId:'fromDate_Id',							
					//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
					endDateField : 'toDate_Id',
					vtype : 'daterange',
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}
				},{
					xtype : 'datefield',
					fieldLabel : getProgramandcourseTranslation('TO_DATE'),
					name : 'toDate',
					itemId:'toDate_Id',							
					//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
					startDateField : 'fromDate_Id',
					vtype : 'daterange',
    				listeners: {
    					render: function(field) {
    						return dateFormatRender(field);
    					}
    				}
				}
				]},{
					xtype: 'fieldcontainer',
					width: 'auto',
					
					items: [{
						xtype: 'button',
						text: getCommonTranslation('SEARCH'),
						itemId: 'quickSearchId',
						buttonAlign: 'left',
						ui: 'CustomBtnSubmit',
						formBind:true,
						scale: CONSTANTS.BUTTONSIZE
					},{
						xtype: 'button',
						itemId: 'resetBtn',
						text: getCommonTranslation('RESET'),
						ui:'CustomBtnCancel',
						scale: CONSTANTS.BUTTONSIZE
					}]
				}]
	//}]
});
