/*
 * @author Dharmendra Goyal
 */
Ext.define('Academia.view.coursetransaction.courseSectionManagment.ManageCourseSectionAddProgramPeriodFilter', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.managecoursesectionaddprogramperiodfilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	plugins : "formlabelrequired",
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
	items: [{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:300
		},
		items:[{		
			xtype: 'multiselectcombofield',
		    name: 'programName',
		    itemId: 'programName',
		    fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		    store: Ext.create('Academia.store.program.ManageCourseSectionProgramsStore'),
		    valueField: 'programId',
		    displayField: 'programName',
		    queryParam: 'programName',
		    autoloadStore: false,
		    typeAhead: true,
		    forceSelection: true,
		    hideTrigger: false,
		    triggerAction: 'all',
		    minChars: 3,
		    cls: 'ProgramCourseMultiselectField',
		    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		    listConfig: {
		        listeners: {
		            beforeshow: function(picker) {
		                picker.minWidth = picker.up('combobox').getSize().width;
		            }
		        },
		        loadingText: getCommonTranslation('SEARCHING'),
		        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		        getInnerTpl: function() {
		            return '<div class="search-item">' +
		                '{programName}' +
		                '</div>';
		        }
		    }	
		},{
				xtype: 'multiselectcombofield',
				name: 'batchName',
				itemId:'batchName',
				fieldLabel: getCourseTxCommonTranslation('BATCH'),
				store: Ext.create('Academia.store.program.ManageCourseSectionBatchesStore'),
				valueField: 'batchId',
				displayField: 'batchName',
				queryParam:'batchName',
				disabled:true,
				autoloadStore:false,
				typeAhead : true,
				forceSelection:true,
				hideTrigger:false,
				triggerAction: 'all',
				minChars:3,
				cls:'ProgramCourseMultiselectField',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						},
						
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{batchName}'  +
						'</div>';
					}
				}
	
		},{
				xtype: 'multiselectcombofield',
				name: 'periodName',
				itemId:'periodName',
				fieldLabel: getCourseTxCommonTranslation('PERIOD'),
				store: Ext.create('Academia.store.program.ManageCourseSectionPeriodsStore'),
				valueField: 'periodId',
				displayField: 'periodName',
				queryParam:'periodName',
				autoloadStore:false,
				disabled:true,
				typeAhead : true,
				forceSelection:true,
				hideTrigger:false,
				triggerAction: 'all',
				minChars:3,
				cls:'ProgramCourseMultiselectField',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{periodName}'  +
						'</div>';
					}
				}

		}]  
	},{
		xtype:'fieldcontainer',
		width: '100%',
		items:[{  
			xtype: 'button',
			itemId: 'searchBtn',
			formBind:true,
			text: getCourseTxCommonTranslation('SEARCH'),
			ui:'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			disabled:true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCourseTxCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	}]
});