Ext.require([
             'Ext.ux.form.MultiSelect'
             ]);

Ext.define('Academia.view.coursetransaction.coursereading.CourseReadingDetails',{
//	extend : 'Ext.form.FormPanel',
	extend: 'Academia.view.common.CustomFieldForm',
	customFieldEntity:CONSTANTS.COURSE_READING_CD,
	alias : 'widget.coursereadingdetails',
	title : getCourseTxCommonTranslation('COURSE_READING'),
	autoScroll: true,
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	frame:true,
	method: 'POST',
	defaults: {
		labelAlign: 'top',
		width: 226
	},
	plugins : "formlabelrequired",
	items : [{
		xtype : 'hidden',
		name : 'id'
	},{
		xtype : 'hidden',
		name : 'version'
	},{
		xtype : 'hidden',
		name : 'courseReadingObj'
	},{
		xtype : 'hidden',
		name : 'courseReadingDocObj'
	},{
		xtype : 'hidden',
		name : 'courseReadingTopicsIds'
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			name : 'course',
			itemId:'courseReadingCourse_Id',
			fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
			store:'attendance.AssignedCoursesFacultyStore',
			valueField : 'courseId',
			displayField : 'courseCodeName',
			width:460,
			allowBlank : false,
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
       	    enableKeyEvents  : 'true',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
//			triggerAction: '',
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'  +
					'</div>';
				}
			}
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{  
			xtype: 'customcombobox',
			name:'COMPONENT_ID',
			itemId: 'componentId',
			//store:'course.coursetopic.CourseComponentStore',
			store:'coursetransaction.coursereading.ComponentByParentCourseId',
			displayField: 'value',
			valueField: 'id',
			editModeCourseId: '',
			fieldLabel:getCourseTxCommonTranslation('COMPONENT'),
			allowBlank:false,
			typeAhead:true,
			forceSelection:true,
			hidden: true
		},{
			xtype:'customcombobox',
			fieldLabel:getCourseTxCommonTranslation('READING_TYPE'),
			itemId:'courseReadingType_Id',
			name:'invtTypeMaster',
//			store:'coursetransaction.coursereading.TopicReading',
			store:'course.readingmaterial.ReadingTypeStore',
			valueField:'id',
			displayField:"value",
			allowBlank:false
		}
		]},
		{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
			        	 xtype: 'multiselectcombofield',
			        	 name: 'invtItemMaster',
			        	 itemId:'invtItemMaster_Id',
			        	 store:'course.readingmaterial.ReadingNameStore',
			        	 fieldLabel: getCourseTxCommonTranslation('READING_NAME'),
			        	 width: 460,
			        	 valueField: 'id',
			        	 displayField: 'code',
			        	 queryParam:'inventoryItemName',
			        	 allowBlank: false,
			        	 minChars:3,
			        	 typeAhead:true,
			        	 disabled:true,
			        	 triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			        	 enableKeyEvents  : 'true',
			        	 hideTrigger:false,
			        	 forceSelection:true,
			        	 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			        	 listConfig: {
			        		 listeners: {
			        			 beforeshow: function(picker) {
			        				 picker.minWidth = picker.up('combobox').getSize().width;
			        			 }
			        		 },
			        		 loadingText: getCommonTranslation('SEARCHING'),
			        		 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			        		 getInnerTpl: function() {
			        			 return '<div class="search-item">' +
			        			 '{code}' +
			        			 '</div>';
			        		 }
			        	 }
			         },/*{
	        	  xtype:'textfield',
	        	  name:'author',
	        	  itemId:'author_Id',
	        	  fieldLabel:getCourseTxCommonTranslation('AUTHOR'),
	        	  allowBlank:true,
	        	  hidden:true,
	        	  enforceMaxLength : true,
				  maxLength:60
	          },*/
			         {
			        	 xtype:'textfield',
			        	 name:'linkPath',
			        	 fieldLabel:getCourseTxCommonTranslation('LINK'),
			        	 itemId:'link_Id',
			        	 allowBlank:false,
			        	 hidden:true
			         }
			         ]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'customcombobox',
				name : 'distributionMode',
				fieldLabel : getCourseTxCommonTranslation('DISTRIBUTION_MODE'),
				store : 'coursetransaction.coursereading.DistributionMode',
				valueField : 'id',
				displayField : 'value',
				allowBlank : false
			},{
				xtype: 'checkboxfield',
				width: 'auto',
				labelAlign: 'right',
				boxLabel: getCourseTxCommonTranslation('READING_COMPULSORY'),
				name: 'whetherCompulsory',
				inputValue : true,
				uncheckedValue: false,
				style:{
					marginTop:'30px'
				}

			}]},{
				xtype: 'checkboxfield',
				width: 'auto',
				labelAlign: 'right',
				itemId:'downlable_Id',
				boxLabel: getCourseTxCommonTranslation('DOWNLOADABLE'),
				name: 'whetherDownloadable',
				inputValue : true,
				uncheckedValue: false,
				hidden:true

			},
			{
				xtype : 'radiogroup',
				fieldLabel : getCourseTxCommonTranslation('TOPIC_TYPE'),
				itemId : 'topicRadio_Id',
				items : [
				         /*{
						   boxLabel : 'General',
						   name : 'topicType',
						   inputValue : 'General',
						   checked : true

					},{
						   boxLabel : 'Specific',
						   name : 'topicType',
						   inputValue : 'Specific'

					}*/
				         ]
			},
			{
				xtype: 'multiselectcombofield',
				name: 'courseReadingTopics',
				itemId:'multiTopics_Id',
				width: 460,
				fieldLabel: getCourseTxCommonTranslation('TOPICS'),
				store:'coursetransaction.coursereading.MaterialType',
				displayField:'value',
				valueField:'id',
				typeAhead:true,
				forceSelection:true,
				//delimiter: null,
				hidden:true

			},
			{
				xtype:'displayfield',
				value:'<b class="menu-title">'+getCourseTxCommonTranslation('UPLOAD_DOC')+'</b>',
				style: {
					textDecoration: "underline"
				}
			},{
				xtype:'fieldcontainer',
				hidden:true,
				layout:'hbox',
				width:'100%',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items:[{
					xtype: 'filefield',
					border:false,
					name: 'courseReadingLinks',
					allowBlank: true,						        
					buttonText: getCommonTranslation('UPLOAD_DOC')
				}]
			},
			{
				xtype:'coursereadingdocumentgrid',
				style:{
					marginLeft:'0px'
				}
			},{
				xtype:'fieldcontainer',
				width:'auto',
				layout : {
					type : 'hbox'
				},
				//width:500,
				items : [ {
					xtype : 'button',
					text : getCommonTranslation('SAVE'),
					itemId : 'courseReading_Add',
					ui : 'CustomBtnSubmit',
					scale : CONSTANTS.BUTTONSIZE,
					formBind : true
				}, {
					xtype : 'button',
					text : getCommonTranslation('RESET'),
					itemId : 'courseReading_Cancel',
					ui : 'CustomBtnCancel',
					scale : CONSTANTS.BUTTONSIZE
				},{
					xtype: 'button',
					name: 'courseReadingDocument',
					text:getCommonTranslation('UPLOAD_DOC'),
					itemId: 'courseReadingUploadId',
					ui: 'CustomBtnThird',
					scale : CONSTANTS.BUTTONSIZE
				} ]
			} 
			]

});