/**
 * @author Rajkumar.Patidar
 */
Ext.define('Academia.view.coursetransaction.facultyTopicAssignment.ProgramBatchSectionFTASearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.programbatchsectionftasearch',
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	defaults: {
		labelAlign:'top',
		width:226
	},
	items: [{
			xtype: 'customcombobox',
			itemId: 'programId',
			name: 'PROGRAM_ID',
			width: 460,
			fieldLabel:getCourseTxCommonTranslation('PROGRAM'),
			store:'common.ProgramStore',
			displayField:'value',
			valueField:'id',
			allowBlank:false,
			typeAhead:true,
			forceSelection:true,
            triggerAction: 'all',
            queryParam:'programName',
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	 			listConfig: {
	 				listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	 				loadingText: getCommonTranslation('SEARCHING'),
	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	 				getInnerTpl: function() {
	 					return '<div class="search-item">' +
	 					'{value}' +
	 					'</div>';
	 				}
	 			}
		  },{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items :[{
					xtype: 'customcombobox',
					itemId:'batchId',
					name: 'PROGRAM_BATCH_ID',
					fieldLabel:getCourseTxCommonTranslation('BATCH'),
					store: 'enquiry.AcademicBatchStore',
					valueField: 'id',
					displayField: 'value',
					allowBlank:false,
					typeAhead:true,
					forceSelection:true	
			       },{
		    	    xtype: 'customcombobox',
					itemId:'periodId',
					name: 'PROGRAM_BATCH_PERIOD_CONFIG_ID',
					fieldLabel:getCourseTxCommonTranslation('PERIOD'),
					store: 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
					valueField: 'id',
					displayField: 'value',
					allowBlank:false,
					typeAhead:true,
					forceSelection:true	  
			       }]
		},{
			xtype: 'customcombobox',
			itemId: 'courseCodeId',
			name: 'COURSE_ID',
			width: 460,
			labelAlign: 'top',
			fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
			store:'coursetransaction.facultytopicassignment.CourseComboStore',
			valueField:'id',
			displayField:'courseCodeName',
			allowBlank:false,
			typeAhead:true,
			forceSelection:true,
            triggerAction: 'all',
            queryParam:'qry',
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	 			listConfig: {
	 				listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	 				loadingText: getCommonTranslation('SEARCHING'),
	 				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	 				getInnerTpl: function() {
	 					return '<div class="search-item">' +
	 					'{value}' +
	 					'</div>';
	 				}
	 			}
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'customcombobox',
			name:'componentSectionId',
			itemId: 'componentSectionItemId',
			store:'course.coursetopic.CourseComponentStore',
			displayField: 'value',
			valueField: 'id',
			fieldLabel:getCourseTxCommonTranslation('COMPONENT'),
			allowBlank:false,
			typeAhead:true,
			forceSelection:true,
			hidden:true
		},{
			xtype: 'customcombobox',
			name:'courseSectionId',
			itemId: 'courseSectionId',
			store:'coursetransaction.facultytopicassignment.CourseSectionByPeriodIDCourseIDStore',
			displayField: 'value',
			valueField: 'id',
			fieldLabel:getCourseTxCommonTranslation('SECTION'),
			allowBlank:false,
			disabled:true,
			typeAhead:true,
			forceSelection:true
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		
		items: [{
			xtype: 'button',
			text: getCourseTxCommonTranslation('SEARCH'),
			itemId: 'SearchBtn',
			buttonAlign: 'left',
			formBind:true,
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});