/**
 * @author Rajkumar.Patidar
 */
Ext.define('Academia.view.coursetransaction.homework.HwStudentWise', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.hwstudentwise',
	//title : getCommonTranslation('QUICK_SEARCH'),
    frame: false,
    layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    items: [{
       	xtype: 'fieldcontainer',
       	width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			labelAlign:'top',
			width:223
		},
		items:[{
			xtype: 'customcombobox',
			name:'facultyName',
			itemId:'facultyName_Id_studentWise',
			store: Ext.create('Academia.store.attendance.FacultyCodeSmartSearch'),
			fieldLabel :getCommonTranslation('FACULTY_CODE'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			minChars:3,
			hidden:false,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			forceSelection:true,
			hidden: true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'studentName',
			itemId:'studentName_Id',
			fieldLabel: getCourseTxCommonTranslation('HW_STUDENT_NAME'),
			store:'coursetransaction.homework.HW_StudentNameDropDown',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:false,
			allowBlank: false,
			hidden: true,
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			queryParam:'studentName',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},
		{
			xtype: 'customcombobox',
			name: 'admission',
			itemId:'admission_Id',
			fieldLabel: getCourseTxCommonTranslation('HW_ADMISSION_ID'),
			store:'coursetransaction.homework.HW_StudentNameDropDown',
			displayField:'code',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			allowBlank: false,
			hidden: true
		}
		]
        }]
});