/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.coursetransaction.homework.evaluationdetails.EvaluationDetailsGridNew', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.evaluationdetailsgridnew',
	store: 'coursetransaction.homework.submissiondetails.EvaluationDetailsGrid',
	border: true,
	autoScroll: false,
	frame:false,
	selType:'checkboxmodel',
    selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	viewConfig: {
		stripeRows: true
	},
	title : getCourseTxCommonTranslation('HW_EVALUATION_DETAILS'),	
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}/*,{
		xtype : 'button',
		text:getProgramandcourseTranslation('UPLOAD_DOCUMENT'),
		itemId:'evaluationUploadDocument'
	}*/],
	columns: [
		{
			header: getCourseTxCommonTranslation('HW_GROUP_NAME'),
			dataIndex: 'groupName',
			flex:1,
			sortable:true
		}, {
			header: getCommonTranslation('RANDOM_CODE'),
			dataIndex: 'randomNumber',
			flex:1,
			sortable:true
		},{
			header: getCourseTxCommonTranslation('HW_SUBMISSION_STATUS'),
			dataIndex: 'submissionStatus',
			flex:1,
			sortable:true
		},{
			header: getCourseTxCommonTranslation('HW_EVALUATION_MARK_GRADE'),
			dataIndex: 'markObtained',
			flex:1,
			sortable:true
		},{
			header: getCourseTxCommonTranslation('HW_EVALUATION_REMARKS'),
			dataIndex: 'remarks',
			flex:1,
			sortable:true,
			renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				if(!isNullOrEmpty(val)){
					rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
					rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 4;-webkit-box-orient: vertical;line-height: 15px;max-height: 73px;min-width: 16ch;max-width: 17ch;';
				}
				return val;
			}
		},{
			header: getCourseTxCommonTranslation('HW_FILE_NAME'),
			dataIndex: 'documents',
			flex:1,
			sortable:true,
			renderer: function (value) {
				if(value.length>0){
					return '<a href="#">'+value[0].name+'</a>';
				}
			}
		},{
			header: getProgramandcourseTranslation('DEENROLLED_AFTER_ENROLLMENT'),
			dataIndex: 'whetherUnEnrolled',
			sortable:true,
			flex: 1,
			hidden:true,
			renderer: function (value,rec) {
				if(!value){
					return 'No';
				}else{
					return 'Yes';
				}
			}
		}]
});