/**
 * Dharmendra.Prajapati
 * 
 */
Ext.define('Academia.view.coursetransaction.managedistribution.CreateDistributionSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.createdistributionsearch',  
	plugins : "formlabelrequired",
	autoScroll: true,
//	frame: true,
	method: 'POST',
	standardSubmit: false,
	style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
	items: [
	        {
	    		xtype : 'fieldcontainer',
	    		width: 'auto',
	    		layout : {
	    			type : 'hbox'
	    		},
	    		defaults : {
	    			width : 226,
	    			labelAlign : 'top'
	    		},
	    		items : [{
	        		xtype: 'multiselectcombofield',
	        		width: 460,
	        		cls: 'multiselectAcademyLocation',
	        		//height: 'auto',
	        		name: 'multiselectAcademyLocation',
	        		itemId: 'multiselectAcademyLocationId',
	        		allowBlank : false,
	        		fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
//	        		translationKey: 'ACADEMY_LOCATION',
	        		store:'common.AcademyLocationNameSeparated',
	        		displayField:'value',
	        		valueField:'id',
	        		matchFieldWidth:true,
	        		queryMode:'local',
	        		listConfig: {
	        			listeners: {
	        				beforeshow: function(picker) {
	        					picker.width = picker.up('combobox').getSize().width;
	        				}
	        			},
	        			loadingText: getCommonTranslation('SEARCHING'),
	        			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        			getInnerTpl: function() {
	        				return '<div class="search-item">' +
	        				'{code}' +
	        				'</div>';
	        			}
	        		}
	    		}]
	    		
	        },
	        
	        
	        
	        {
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'hidden',
			name : 'id'
		},{
			xtype : 'textfield',
			name : 'listName',
			itemId : 'listName',
			allowBlank : false,
			fieldLabel : getCourseTxCommonTranslation('LIST_NAME')
		},{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('PROGRAM'),
//			translationKey: 'PROGRAM',
			name : 'programId',
			itemId : 'programId',
			store:'common.ProgramByAcademyLocationStore',
			displayField:'valueCode',
			valueField:'id',
			width:460,
			allowBlank : false,
			typeAhead:false,
        	forceSelection:true,
        	queryParam:'programName',
        	minChars:3,
        	triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        	enableKeyEvents  : 'true',
        	hideTrigger:false,
        	forceSelection:true,
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{code} / {value}' +
        			'</div>';
        		}
        	}
		}
		]},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'batchId',
				itemId:'batchId',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				disabled:true,
				allowBlank : false,
				store: 'enquiry.AcademicBatchStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				allowBlank : false,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'periodId',
				itemId:'periodId',
				fieldLabel: getExaminationTranslation('PERIOD'),
				store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				allowBlank : false,
				typeAhead:true,
				disabled:true
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('SECTION'),
				width: 226,
				labelAlign: 'top',
				name : 'sectionId',
				itemId : 'sectionId',
				store:'attendance.SectionAndFacultyByPeriodID',
				displayField : 'sectionCode',
				valueField : 'sectionId',
				typeAhead : true,
				disabled:true,
				allowBlank: false,
				forceSelection : true
			}
			]},{
				xtype: 'fieldcontainer',
				width: 'auto',
				items: [{
					xtype: 'button',
					text: getCommonTranslation('SEARCH'),
					itemId: 'searchBtn',
					buttonAlign: 'left',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE,
					formBind:true
				},{
					xtype: 'button',
					text: getCourseTxCommonTranslation('RESET'),
					itemId: 'resetBtn',
					buttonAlign: 'left',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE	        				
				}]
			}]
      //}]
});

