/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.coursetransaction.manageperiodenrollment.OptionalPeriodEnrollmentStructure', {
	extend : 'Ext.panel.Panel',
	alias : 'widget.optionalperiodenrollmentstructure',
	modal:true,
	autoScroll:false,
	items : [{
		xtype:'form',
		border: true,
		style:{
			marginTop: '0px !important'
		},
		items:[{
			xtype: 'fieldcontainer',
			margin: '10 10 0 10',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 420,
				labelWidth:120,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'hiddenfield',
				name: 'optionalPeriodId'
			},{
				xtype: 'hiddenfield',
				name: 'currentPeriodId'
			},{
				xtype:'displayfield',
				name:'programName',
				fieldLabel:'<b>'+getCommonTranslation('PROGRAM_CODE_OR_NAME')+'</b>'
			},{
				xtype:'displayfield',
				name:'bathName',
				fieldLabel:'<b>'+getCommonTranslation('BATCH')+'</b>'
			},{
				xtype:'displayfield',
				name:'currentPeriod',
				fieldLabel:'<b>'+getCommonTranslation('CURRENT_PERIOD')+'</b>'
			}]
		},
		{
			xtype: 'fieldcontainer',
			margin: '10 10 10 10',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 420,
				labelWidth:120,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'optionalPeriod',
				fieldLabel:'<b>'+getCommonTranslation('OPTIONAL_PERIOD')+'</b>'
			}]
		}]
	},{
		xtype: 'grid',
		itemId:'optionPeriodEnrollmentGrid',
		frame:false,
		border:true,
		autoScroll:true,
		store:'coursetransaction.manageperiodenrollment.OptionalPeriodEnrollGridStore',
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		style:{
			marginTop: '-15px !important'
		},
		title: getCommonTranslation('LIST_OF_STUDENT'),
		tbar:[{
			xtype: 'container',
			width: '100%',
			layout: {
				type: 'hbox'
			},
			items: [
				{
					xtype: 'button',
					text: getCommonTranslation('ENROLL'),
					itemId: 'optionalPeriodGridEnrollBtn',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE,
					disabled: true
				},{
					xtype: 'button',
					text: getCommonTranslation('RESET'),
					itemId: 'optionalPeriodGridResetBtn',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE
				},{
					xtype:'trigger',
					emptyText: getCommonTranslation('ENTER_ADMISSION_ID_STUDENT_NAME_STUDENT_ID'),
					width: 460,
					name:'optionalEnrollmentGridSearch',
					itemId:'optionalEnrollmentGridSearch',
					cls: 'SearchTextFieldWithSmallHeader '+Ext.baseCSSPrefix + 'form-search-trigger',
                    triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
					hidden:false,
					enableKeyEvents: true,
					style:{
						'margin-left': '5px !important'
					}
				}
				]
		}],
		columns: [{
	    	header:getCourseTxCommonTranslation('SELECT'),
	    	dataIndex : '',
	    	width: 65,
	    	renderer: function(value, metadata,record,rowIndex,colIndex,store,view) {
	    		if(isNullOrEmpty(record.data.optionalPeriodEnrollmentId)){
	    			return Ext.String.format("<input type='checkbox' name='rowSel' value='checkbox' />");
	    		}
	    		else{
	    			return Ext.String.format("<input type='checkbox' name='rowSel' value='checkbox' checked=checked disabled/>");
	    		}
	    	}
	    },{
			header: getExaminationTranslation('ADMISSION_ID'),
			dataIndex: 'admissionCode',
			flex:.1,
			sortable:true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.admissionCode)){
					return value;
				}
			}
		},{
			header: getExaminationTranslation('STUDENT_ID'),
			dataIndex: 'studentCode',
			flex:.1,
			sortable:true
		},{
			header: getExaminationTranslation('STUDENT_NAME'),
			dataIndex: 'studentName',
			flex:.2,
			sortable: true,
			renderer:function(value,meta,record){
				if(!isNullOrEmpty(record.data.studentName)){
					return value;
				} else {
					return '<span style=\'color:red\'>N/A</span>'
				}
			}
		}],
		plugins: [{
			ptype : 'cellediting',
			clicksToEdit: 1,
			listeners: {
	            beforeedit: function(ed,e){
	            	e.grid.getSelectionModel().deselectAll();
	            }
	        }
		}]
	}]
});
