Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.ExtendedTimeTableImportStructure', {
	extend : 'Ext.panel.Panel',
	alias : 'widget.extendedTimeTableImportStructure',
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,
	 layout: 'fit',
	listeners: {
        afterrender: function (panel) {
            // IMPORTANT: set height via JS, not CSS
            panel.setHeight(Ext.Element.getViewportHeight() * 0.85);

            // FORCE scroll on BODY
            panel.body.setStyle({
                overflowY: 'auto',
                overflowX: 'hidden'
            });

            panel.doLayout();
        }, activate: function (tab) {
            var parent = tab.up('timetablestructure');

            if (parent && parent.body) {
                parent.body.setStyle('overflow', 'hidden');
            }
        },

        deactivate: function (tab) {
            var parent = tab.up('timetablestructure');

            if (parent && parent.body) {
                parent.body.setStyle('overflow', 'auto'); 
            }
        }
    },
    items: [{
        xtype: 'panel',
        layout: 'fit',
        border: false,

        items:[{
			xtype : 'extendedTimeTableImport',
			itemId: 'extendedTimeTableImport',
			isGridConfigurable: true, 
			enableColumnHide: false,
			cbViewCode: CONSTANTS.CB.PROGRAM_LIST_VIEWCODE, 
		}]
    }]
	
});


