/**
 * @author Raghavendra.Soni
 * 
 */
Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.ImportSessionTopicsDownloadCBSPanel', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.importsessiontopicsdownloadcbspanel',
	autoScroll:false,
	frame:false,
	cls: 'horizontalScrollingFixed',
	style: {
		margin: 0
	},
	defaults : {
		width : '100%'
	},
    plugins: "formlabelrequired",
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype : 'fieldcontainer',
		layout : 'hbox',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTermCBS',
			itemId : 'academicTermIdCBS',
			displayField : 'value',
			store:Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.AcademicTermStoreForCBSSessionTopicMapping'),
			valueField : 'id',
			typeAhead : true,
			editable : false,
			allowBlank: false
		}, {
			xtype: 'multiselectcombofield',
			name: 'batch',
			width:446,
			itemId: 'batchId',
			fieldLabel: getProgramandcourseTranslation('PROGRAM_BATCH'),
			store: Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.ProgramBatchStoreForCBSSessionTopicMapping'),
			displayField:'valueCode',
			valueField:'id',
			queryParam:'programName',
			typeAhead : true,
			allowBlank:true,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			disabled:true,
			minChars:3,
			cls:'ProgramCourseMultiselectField',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		},/*{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('PROGRAM_BATCH'),
			name : 'batch',
			itemId : 'batchId',
			width : 446,
			disabled:true,
			store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.ProgramBatchStoreForCBSSessionTopicMapping'),
			displayField : 'valueCode',
			valueField : 'id',
			forceSelection : true,
			allowBlank:true,
			queryParam:'programName',
			minChars:3,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{batch}'  +
					'</div>';
				}
			}
		}*/]
	},{
		xtype : 'fieldcontainer',
		layout : 'hbox',
		defaults : {
			width : 446,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'multiselectcombofield',
			fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
			name : 'course',
			itemId : 'course_Id',
			store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.CourseStoreForCBSSessionTopicMapping'),
			valueField: 'id',
			displayField: 'value',
			typeAhead : true,
			forceSelection : true,
			allowBlank:false,
			queryParam:'name',
			minChars:3,
			cls:'ProgramCourseMultiselectField',
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
	},{
		xtype : 'fieldcontainer',
		layout : 'hbox',
		defaults : {
			width : 446,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'multiselectcombofield',
			fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
			name : 'downloadCourseVariantName',
			itemId : 'downloadCourseVariant_ID',
			store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.CourseVariantStoreForCBSSessionTopicMapping'),
			displayField : 'courseVariantCode',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true,
			allowBlank:true,
			queryParam:'name',
			minChars:3,
			maxLength:9999,
			maxSelections :9999,
			cls:'receiptHeaderMultiselect',
			disabled:true,
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		style:{
			marginTop:'20px !important'
		},
		items: [{
			xtype:'button',
			itemId:'importSessionTopicCBSDownload',
			text:getCommonTranslation('DOWNLOAD_TEMPLATE'),
			ui: 'CustomBtnSubmit',
			style:{marginLeft:'0px !important'},
			formBind:true
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'importSessionTopicCBSResetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	}]
});
