/**
 * @author Raghavendra.Soni
 * 
 */
 Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.ImportSessionTopicsDownloadPBSPanel', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.importsessiontopicsdownloadpbspanel',
	autoScroll:false,
	frame:false,
	cls: 'horizontalScrollingFixed',
	style: {
		margin: 0
	},
	defaults : {
		width : '100%'
	},
    plugins: "formlabelrequired",
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype : 'fieldcontainer',
		layout : 'hbox',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTermPBS',
			itemId : 'academicTermIdPBS',
			displayField : 'value',
			store:Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.AcademicTermStoreForPBSSessionTopicMapping'),
			valueField : 'id',
			typeAhead : true,
			editable : false,
			allowBlank: false
		}, {
			xtype: 'multiselectcombofield',
			name: 'batchPBS',
			width:446,
			itemId: 'batchIdPBS',
			fieldLabel: getProgramandcourseTranslation('PROGRAM_BATCH'),
			store: Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.ProgramBatchStoreForPBSSessionTopicMapping'),
			displayField:'valueCode',
			valueField:'id',
			queryParam:'programName',
			typeAhead : true,
			allowBlank:false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			disabled:true,
			minChars:3,
			cls:'ProgramCourseMultiselectField',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		}]
	},{
		xtype : 'fieldcontainer',
		layout : 'hbox',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('PERIOD'),		
			name: 'periodIdPBS',
			itemId:'periodIdPBS',
			store: Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.PeriodStoreForPBSSessionTopicMapping'),
			valueField: 'id',
			displayField: 'value',
			typeAhead : true,
			editable : false,
			disabled:true,
			allowBlank: true
		}, {
			xtype : 'multiselectcombofield',
			fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
			name : 'coursePBS',
			itemId : 'course_IdPBS',
			width:446,
			store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.CourseStoreForPBSSessionTopicMapping'),
			valueField: 'id',
			displayField: 'value',
			typeAhead : true,
			forceSelection : true,
			allowBlank:true,
			queryParam:'name',
			minChars:3,
			cls:'ProgramCourseMultiselectField',
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		style:{
			marginTop:'20px !important'
		},
		items: [{
			xtype:'button',
			itemId:'importSessionTopicPBSDownload',
			text:getCommonTranslation('DOWNLOAD_TEMPLATE'),
			ui: 'CustomBtnSubmit',
			style:{marginLeft:'0px !important'},
			formBind:true
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'importSessionTopicPBSResetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	}]
});
