Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.TimeTableImportStructure', {
    extend : 'Ext.panel.Panel',
    alias  : 'widget.timeTableImportStructure',

    layout: 'fit',

    listeners: {
        afterrender: function (panel) {
            // IMPORTANT: set height via JS, not CSS
            panel.setHeight(Ext.Element.getViewportHeight() * 0.85);

            // FORCE scroll on BODY
            panel.body.setStyle({
                overflowY: 'auto',
                overflowX: 'hidden'
            });

            panel.doLayout();
        }, activate: function (tab) {
            var parent = tab.up('timetablestructure');

            if (parent && parent.body) {
                parent.body.setStyle('overflow', 'hidden');
            }
        },

        deactivate: function (tab) {
            var parent = tab.up('timetablestructure');

            if (parent && parent.body) {
                parent.body.setStyle('overflow', 'auto'); 
            }
        }
    },

    bodyStyle: {
        margin: CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL
    },
    
    items: [{
        xtype: 'panel',
        layout: 'fit',
        border: false,

        items: [{
            xtype : 'timeTableImport',
            itemId: 'timeTableImport'
        }]
    }]
});
