/**
 * @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.mastertimetable.UploadTemplate',{   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.uploadtemplate',  
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
		xtype : 'fieldcontainer',
		defaults : {
	    width: '100%',
		layout : {
			type : 'hbox'
		},
		labelAlign : 'top'
		},items : [{
			xtype : 'radiogroup',
			itemId:'templateTypeId',
			defaults: {
	   		 flex: 1,
			width: 200
	   	 },
	   	items: [{
			boxLabel: getProgramandcourseTranslation('DOWNLOAD_TEMPLATE'),
			name: 'templateType',
			inputValue: 'Download_Template',
			checked:true
		},{
			boxLabel: getCommonTranslation('UPLOAD_TEMPLATE'),
			name: 'templateType',
			inputValue: 'Upload_Template'
		},{
      		xtype:'checkbox',
    		name: 'allFacultyCheck',
    		boxLabel: getCommonTranslation('ALL_FACULTY_CHECK_IN_LOADER'),
    		itemId:'allFacultyCheckId',
    	    inputValue: true,
    	    width: 300,
    		uncheckedValue: false,
    		cls: 'checkBoxEllipsisCls'
  		 }]
		},{
			xtype:'uploadoptionradiogroup',
			width: 300,
			margin: 0,
			itemId:'importTimeTableUploadOptionRadioGroupItemId',
			hidden:true,
		}]},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items:[{
    			xtype : 'customcombobox',
    			name : 'downloadType',
    			itemId:'downloadType',
    			fieldLabel : getCommonTranslation('COURSE_SECTION_TYPE_FOR_TEMPLATE'),
//    			translationKey: 'COURSE_SECTION_TYPE_FOR_TEMPLATE',
    			store:Ext.create('Academia.store.course.SectionTypeStore'),
    			valueField : 'id',
    			displayField : 'value',
    			triggerAction : 'all',
    			editable : false,
    			allowBlank : true,
    			listeners:{
    				render:function(obj){
    					var store = obj.getStore();
    					var form = obj.up('form').getForm();
    					store.load({
    						callback: function(records, operation, success) {
    							if (success) {
    								obj.setValue(obj.getStore().data.items[0].data.id);
    							}
    						}
    					});
    				}
    			}
    		},{
    			xtype : 'customcombobox',
    			name : 'uploadType',
    			itemId:'uploadType',
    			fieldLabel : getCommonTranslation('UPLOAD_TYPE'),	
    			store:Ext.create('Academia.store.course.SectionTypeStore'),
    			valueField : 'id',
    			displayField : 'value',
    			triggerAction : 'all',
    			editable : false,
    			allowBlank : true,
    			hidden:true,
    		}]
		},{
    			xtype : 'fieldcontainer',
    			width: 'auto',
    			layout : {
    				type : 'hbox'
    			},
    			defaults : {
    				width : 226,
    				labelAlign : 'top'
    			},
    			items:[{
    				xtype : 'customcombobox',
    				name : 'calendar',
    				itemId:'calendarId',
    				fieldLabel : getProgramandcourseTranslation('CALENDAR'),
    				//store : 'calendar.AccessibleCalendarStore',
    				store : 'facilitiesresources.resourcemaster.MappedCalenderStore',
    				displayField : 'value',
    				valueField : 'id',
    				allowBlank : false,
    				hidden:true
    			},{
    				xtype: 'customcombobox',
    				name: 'importUtilityMasterId',
    				itemId:'moduleName',
    				store:'importutility.ModuleName',
    				fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
    				valueField: 'id',
    				displayField: 'value',
    				typeAhead:true,
    				forceSelection:true,
    				allowBlank:false,
    				hidden:true
    			},{
    				xtype : 'customcombobox',
    				fieldLabel : getCourseTxCommonTranslation('PROGRAM_BATCH'),
    				name : 'batch',
    				itemId : 'batchId',
    				width : 446,
    				disabled:true,
    				store : 'coursetransaction.sectioncoursecoverageplan.mastertimetable.BatchByCalendar',
    				displayField : 'batch',
    				valueField : 'id',
    				allowBlank : false,
    				forceSelection : true,
    				queryParam:'qry',
    				minChars:3,
    				typeAhead:false,
    				hidden:true,
    	            //hideTrigger:true,
    	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    	            //triggerAction: '',
    	            //forceSelection:true,
    				  listConfig: {
    					  listeners: {
    							beforeshow: function(picker) {
    								picker.minWidth = picker.up('combobox').getSize().width;
    							}
    						},
    		                loadingText: getCommonTranslation('SEARCHING'),
    		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    		                getInnerTpl: function() {
    		                    return '<div class="search-item">' +
    		                    '{batch}'  +
    		                    '</div>';
    		                }
    		            }
    			},{
    				xtype : 'customcombobox',
    				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
    				name : 'cbsProgram',
    				itemId : 'cbsProgramId',
    				width : 446,
    				disabled:true,
    				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.ProgramBatchByCalendarStore'),
    				displayField : 'valueCode',
    				valueField : 'id',
    				allowBlank : true,
    				forceSelection : true,
    				queryParam:'qry',
    				minChars:3,
    				typeAhead:false,
    				hidden:true,
    	            //hideTrigger:true,
    	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    	            //triggerAction: '',
    	            //forceSelection:true,
    				  listConfig: {
    					  listeners: {
    							beforeshow: function(picker) {
    								picker.minWidth = picker.up('combobox').getSize().width;
    							}
    						},
    		                loadingText: getCommonTranslation('SEARCHING'),
    		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    		                getInnerTpl: function() {
    		                    return '<div class="search-item">' +
    		                    '{batch}'  +
    		                    '</div>';
    		                }
    		            }
    			}]
    		},{
    			xtype : 'fieldcontainer',
    			width: 'auto',
    			layout : {
    				type : 'hbox'
    			},
    			defaults : {
    				width : 226,
    				labelAlign : 'top'
    			},
    			items:[{
    				xtype : 'customcombobox',
    				fieldLabel : getCourseTxCommonTranslation('BATCH'),
    				name : 'cbsBatch',
    				itemId : 'cbsBatchId',
    				disabled:true,
    				store : Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.ProgramBatchByCalendarStore'),
    				displayField : 'value',
    				valueField : 'id',
    				allowBlank : true,
    				typeAhead : true,
    				forceSelection : true,
    				hidden:true
    			},{
    				xtype : 'customcombobox',
    				fieldLabel : getCourseTxCommonTranslation('PERIOD'),
    				name : 'period',
    				itemId : 'periodId',
    				disabled:true,
    				store : 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.PeriodSection',
    				displayField : 'value',
    				valueField : 'id',
    				allowBlank : false,
    				typeAhead : true,
    				forceSelection : true,
    				hidden:true
    			},{
    				xtype : 'customcombobox',
    				fieldLabel : getCourseTxCommonTranslation('SECTION'),
    				name : 'section',
    				itemId : 'sectionId',
    				store : 'attendance.SectionAndFacultyByPeriodID',
    				displayField : 'sectionCode',
    				valueField : 'sectionId',
    				allowBlank : false,
    				disabled:true,
    				typeAhead : true,
    				forceSelection : true,
    				hidden:true
    			},{
    				xtype : 'filefield',
    				ui : 'CustomBtnThird',
    				width: 460,
    				fieldLabel : getCommonTranslation('UPLOAD_FILE'),
    				buttonText : getCommonTranslation('BROWSE_FILE'),
    				itemId : 'uploadFileField',
    				name : 'file',
    				allowBlank:false,
    				validateOnChange : true,
    				hidden:true,
    				listeners:{
    		            change: function(fileField, value) {
    		                value = value.replace('C:\\fakepath\\', '');
    		                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
    		                fileField.setRawValue(newValue);
    		                if (!isNullOrEmpty(newValue)) {
    		                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
    		                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
    		                    if (!baseController.isValidFileExtensionForLoader(extension)) {
    		                        fileField.reset();
    		                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
    		                    }
    		                }
    		            }
    		        }
    			}]
    		},{
    			xtype : 'fieldcontainer',
    			width: 'auto',
    			layout : {
    				type : 'hbox'
    			},
    			defaults : {
    				//width : 226,
    				labelAlign : 'top'
    			},
    			items:[{
				 xtype: 'button',
				 text: getProgramandcourseTranslation('DOWNLOAD_TEMPLATE'),
	             itemId: 'downoladtemplate',
	             formBind:false,
	             ui: 'CustomBtnSubmit',
	             hidden: true,
	        },{
				xtype: 'button',
				action: 'Submit',
				text: getTranslation('UPLOAD_DATA'),
				formBind: true,
				itemId: 'programBatchUpload',
				ui: 'CustomBtnSubmit',
				//scale: CONSTANTS.BUTTONSIZE,
				hidden: true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				ui: 'CustomBtnCancel',
				itemId: 'resetBtn',
				scale: CONSTANTS.BUTTONSIZE,
				hidden: true
			}]
    		}]
});