/**
 * @author ravindra.merawat
 * 
 */
Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.mastertimetable.XMLUploadTemplate',{   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.xmluploadtemplate',  
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	items: [{
    			xtype : 'fieldcontainer',
    			width: 'auto',
    			layout : {
    				type : 'hbox'
    			},
    			defaults : {
    				width : 226,
    				labelAlign : 'top'
    			},
    			items:[{
            xtype: 'customcombobox',
            fieldLabel: getProgramandcourseTranslation('ACADEMY_LOCATION'),
            name: 'ACAD_LOC_ID',
            itemId:'academyLocationComboId',
   			editable : false,
   			allowBlank : false,
            store: 'user.UserAcademyLocationStore',
            displayField: 'value',
            valueField: 'id',
            width:410,
        },{
			xtype : 'customcombobox',
			name : 'calendar',
			itemId: 'calendarId',
			fieldLabel : getProgramandcourseTranslation('CALENDER'),
			store : 'facilitiesresources.resourcemaster.MappedCalenderStore',
			displayField : 'value',
			valueField : 'id',
			allowBlank : false,
			disabled : true,
			editable : false
		}]
    		},{
    			xtype : 'fieldcontainer',
    			width: 'auto',
    			layout : {
    				type : 'hbox'
    			},
    			defaults : {
    				width : 226,
    				labelAlign : 'top'
    			},
    			items:[{
			xtype : 'customcombobox',
			name : 'academicTerm',
			itemId : 'academicTermId',
			fieldLabel : getProgramandcourseTranslation('ACADEMIC_TERM'),
			store : Ext.create('Academia.store.user.UserAcademyTermsByALStore'),
			allowBlank : false,
			editable : false,
			disabled : true,
			valueField : 'id',
			displayField : 'value'
		},{
    				xtype : 'filefield',
    				ui : 'CustomBtnThird',
    				width: 460,
    				fieldLabel : getProgramandcourseTranslation('UPLOAD_FILE'),
    				buttonText : getProgramandcourseTranslation('BROWSE_FILE'),
    				itemId : 'uploadFileField',
    				name : 'file',
    				allowBlank:false,
    				validateOnChange : true,
    				listeners:{
    		            change: function(fileField, value) {
    		                value = value.replace('C:\\fakepath\\', '');
    		                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
    		                fileField.setRawValue(newValue);
    		                if (!isNullOrEmpty(newValue)) {
    		                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
    		                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
    		                    if (!baseController.isValidXMLFileExtensionForLoader(extension)) {
    		                        fileField.reset();
    		                        showWarningMessage(getCommonTranslation('ALERT'), getProgramandcourseTranslation('IMPORT_TIME_TABLE_XML_FILE'));
    		                    }
    		                }
    		            }
    		        }
    			}]
    		},{
    			xtype : 'fieldcontainer',
    			width: 'auto',
    			layout : {
    				type : 'hbox'
    			},
    			defaults : {
    				//width : 226,
    				labelAlign : 'top'
    			},
    			items:[{
				xtype: 'button',
				action: 'Submit',
				text: getProgramandcourseTranslation('UPLOAD_XML_DATA'),
				formBind: true,
				itemId: 'xmlUploadBtn',
				ui: 'CustomBtnSubmit',
				//scale: CONSTANTS.BUTTONSIZE,
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				ui: 'CustomBtnCancel',
				itemId: 'resetBtn',
				scale: CONSTANTS.BUTTONSIZE,
			}]
    		}]
});