/**
 * @author Akshay Sharma
 */

 
Ext.define('Academia.view.coursetransaction.sectionmanagement.CourseSectionStudentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.coursesectionstudentgrid',
	store : 'coursetransaction.sectionmanagement.CourseSectionStudentStore',
	//id:'courseSection_editor',
	title: getProgramandcourseTranslation('ENROLLED_STUDENTS'),
	border: true,
	autoScroll: false,
	selType:'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	viewConfig : {
		stripeRows :  CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	tbar: [{
        	xtype : 'splitbutton',
      	    itemId:'spBtnMoreActions',
      	    hidden:true,
      	    text : getCourseTxCommonTranslation('MOREACTIONS'),
      	    menu:[{
      		    text:getCourseTxCommonTranslation('ASSIGN_SECTION'),
      		    itemId:'assignSectionforCourseLink'
      	    }]
    }],
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'coursetransaction.sectionmanagement.CourseSectionStudentStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	columns: [/*{
		hidden : true,
		dataIndex : 'id'
	},*/{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentId',
		flex:1,
		renderer:function(value,meta,record){
			if(record.data.studentId == 0){
				return record.data.studentId ;
			} else {
				return '<a href=#>'+record.data.studentId +'</a>'
			}
		}
	},{
		header : getCourseTxCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionId',
		flex:1
	},{
		header : getCourseTxCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_FIRST_NAME'),
		dataIndex : 'firstName',
		flex:1,
		hidden :true
	},{
		header : getCommonTranslation('STUDENT_MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex:1,
		hidden :true
	},{
		header : getCommonTranslation('STUDENT_LAST_NAME'),
		dataIndex : 'lastName',
		flex:1,
		hidden :true
	},{
		header : getCourseTxCommonTranslation('PROGRAM'),
		dataIndex : 'programCode',
		flex:1
	},{
		header : getCourseTxCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantCode',
		flex:1	
	},{
		header : getCourseTxCommonTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex:1
	},{
		header : getCommonTranslation("PERIOD"),
		dataIndex : 'period',
		flex:1
	},{
		header : getProgramandcourseTranslation('DATE_OF_ENROLLMENT'),
		dataIndex : 'enrolledDate',
		flex:1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('ENROLLMENT_TYPE'),
		dataIndex : 'moduleType',
		flex:1
	}]
	
});