/**
 *  @author Deepak S
 */

Ext.define('Academia.view.coursetransaction.sectionmanagement.ManageCourseSectionAddCourseParametersGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.managecoursesectionaddcourseparametersgrid',
	title : getCommonTranslation('COURSE_PARAMETER'),
	store: 'program.ManageCourseSectionParametersStore',
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: true,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false
	},
	border: true,
	tbar: [{
		xtype: 'button',
		text: getCommonTranslation('SUBMITKYS'),
		itemId: 'submitMapping',
		buttonAlign: 'left',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	}],
	columns: [{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1	 
	},{
		header : getProgramandcourseTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1	 
	},{
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1	 
	},{
		header : getPersonModuleTranslation('COURSE_VARIANT'),
		dataIndex : 'subjectVarient',
		flex : 1,
		editor: {
    		xtype: 'customcombobox',
    		name: 'subjectVarient',
    		itemId: 'courseVariantId',
    		//store: Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
    		displayField : 'courseVariantCode',
			valueField : 'id',
			typeAhead : true,
    		forceSelection: true,
    		editable: false,
    		listeners: {
    			blur: function(combo, r) {
    				/*combo.getStore().on('beforeload', function(){
    					this.getProxy().extraParams = {
    						leaveTypeNotInIDs: null
    					};
    				});
    				combo.getStore().load();*/
    			},
    			focus: function(combo, e, eOpts) {
    				//combo.lastQuery = null;
    				/*var me = this.up('leaveholidaycheckgrid');
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().extraParams = {
    						leaveTypeNotInIDs: me.getAllSelectedLeaveTypeIds(combo)
    					};
    				});
    				combo.getStore().load();*/
    			}
    		}
    	},
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if((isNullOrEmpty(record.get('id')) || record.get('id') == '') && !isNullOrEmpty(value)) {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.courseVariantCode;
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(!isNullOrEmpty(value) && value !== '') {
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('courseVariantCode');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName;
    				}
    			}
    			else{
    				if(Ext.isDefined(record.get('subjectVarient')) && isNullOrEmpty(record.get('subjectVarient'))){
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    		}
    	}
	},{
		header : getCommonTranslation('SUBJECT_TYPE'),
		dataIndex : 'courseType',
		flex : 1,
		editor: {
    		xtype: 'customcombobox',
    		name: 'courseType',
    		itemId: 'courseTypeId',
    		store: Ext.create('Academia.store.common.OptionMandatoryStore'),
    		displayField : 'value',
			valueField : 'id',
			typeAhead : true,
    		forceSelection: true,
    		editable: false,
    		/*listeners: {
    			blur: function(combo, r) {
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().extraParams = {
    						leaveTypeNotInIDs: null
    					};
    				});
    				combo.getStore().load();
    			},
    			focus: function(combo, e, eOpts) {
    				//combo.lastQuery = null;
    				var me = this.up('leaveholidaycheckgrid');
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().extraParams = {
    						leaveTypeNotInIDs: me.getAllSelectedLeaveTypeIds(combo)
    					};
    				});
    				combo.getStore().load();
    			}
    		}*/
    	},
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if((isNullOrEmpty(record.get('id')) || record.get('id') == '') && !isNullOrEmpty(value)) {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(!isNullOrEmpty(value) && value !== '') {
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('value');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName;
    				}
    			}
    			else{
    				if(Ext.isDefined(record.get('courseType')) && isNullOrEmpty(record.get('courseType'))){
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    		}
    	}
	},{
		header : getCBTranslation('eval_seq_detail_minMarks'),
		dataIndex : 'minMarks',
		flex : 1,
		editor: {
			xtype: 'numberfield',
			itemId:'courseOff_id',
			name: 'courseCutOff',
			minValue : 0,
			minText:getCommonTranslation('COURSE_DEFICITS_POINT_MSG'),
			/*validator : function(val) {
				var maxValuefield = this.nextSibling();
				var maxValue = maxValuefield.getValue();
				if (maxValue != null) {
					if (val <= maxValue) {
						maxValuefield
						.clearInvalid();
						return true;
					} else {
						return getCommonTranslation('LESS_THAN_MAX_VALUE');
					}
				} else {
					return true;
				}
			}*/
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if(Ext.isDefined(record.get('minMarks')) && isNullOrEmpty(record.get('minMarks'))){
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
			else{
				return value;
			}
    	}
	},{
		header : getCommonTranslation('education_histories_maximumMarks'),
		dataIndex : 'maxMarks',
		flex : 1,
		editor: {
			xtype: 'numberfield',
			itemId:'courseMaxMarks_Id',
			name: 'courseMaxMark',
			minValue : 1,
			minText:getCommonTranslation('COURSE_DEFICITS_POINT_MSG'),
			/*validator : function(val) {
				var minValueField =this.previousSibling();
				var minValue = minValueField
				.getValue();
				if (minValue != null) {
					if (val >= minValue) {
						minValueField
						.clearInvalid();
						return true;
					} else {
						return getCommonTranslation('MORE_THAN_MIN_VALUE');
					}
				} else {
					return true;
				}
			}*/
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if(Ext.isDefined(record.get('maxMarks')) && isNullOrEmpty(record.get('maxMarks'))){
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
			else{
				return value;
			}
    	}
	},{
		header : getCommonTranslation('COURSE_GRADE'),
		dataIndex : 'courseGradeType',
		flex : 1,
		editor: {
    		xtype: 'customcombobox',
    		name: 'courseMaxMarkCombo',
    		itemId: 'courseGradeId',
    		store: Ext.create('Academia.store.course.CourseGradeStore'),
    		displayField : 'value',
			valueField : 'value',
			typeAhead : true,
    		forceSelection: true,
    		editable: false,
    		listeners: {
    			/*blur: function(combo, r) {
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().extraParams = {
    						leaveTypeNotInIDs: null
    					};
    				});
    				combo.getStore().load();
    			},
    			focus: function(combo, e, eOpts) {
    				//combo.lastQuery = null;
    				var me = this.up('leaveholidaycheckgrid');
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().extraParams = {
    						leaveTypeNotInIDs: me.getAllSelectedLeaveTypeIds(combo)
    					};
    				});
    				combo.getStore().load();
    			}*/
    		}
    	},
    	listeners: {
			render: function(combo){
				combo.getEditor().store.load();
			}
    	},
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if((isNullOrEmpty(record.get('id')) || record.get('id') == '') && !isNullOrEmpty(value)) {
    			try{
    				var index = rec.column.getEditor().store.findExact('value',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('value',value)).data.value;
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(!isNullOrEmpty(value) && value !== '') {
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('value');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName;
    				}
    			}
    			else{
    				if(Ext.isDefined(record.get('courseGradeType')) && isNullOrEmpty(record.get('courseGradeType'))){
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    		}
    	}
	},{
		header : getCBTranslation('eval_seq_detail_minGrade'),
		dataIndex : 'minGrade',
		flex : 1,
		editor: {
    		xtype: 'customcombobox',
    		name: 'courseCutOffComboMin',
    		itemId: 'minGradeId',
    		//store: Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades'),
    		displayField: 'gradeName',
			valuefield:'gradeName',
			typeAhead : true,
    		forceSelection: true,
    		editable: false,
    		/*listeners: {
    			blur: function(combo, r) {
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().extraParams = {
    						leaveTypeNotInIDs: null
    					};
    				});
    				combo.getStore().load();
    			},
    			focus: function(combo, e, eOpts) {
    				//combo.lastQuery = null;
    				var me = this.up('leaveholidaycheckgrid');
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().extraParams = {
    						leaveTypeNotInIDs: me.getAllSelectedLeaveTypeIds(combo)
    					};
    				});
    				combo.getStore().load();
    			}
    		}*/
    	},
    	listeners: {
			render: function(combo){
				var me = this;
				var managecoursesectionaddmappingtab = me.up('managecoursesectionaddmappingtab');
				if(!isNullOrEmpty(managecoursesectionaddmappingtab)){
					if(managecoursesectionaddmappingtab.config.gridRecord.length>0){
						var gridRec = managecoursesectionaddmappingtab.config.gridRecord[0];
						var courseGradeType = gridRec.data.courseGradeType;
						
						combo.getEditor().store.on('beforeload', function(){
	    					this.getProxy().extraParams = {
	    						gradeType: courseGradeType
	    					};
	    				});
						combo.getEditor().store.load();
					}
				}
			}
    	},
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if((isNullOrEmpty(record.get('id')) || record.get('id') == '') && !isNullOrEmpty(value)) {
    			try{
    				var index = rec.column.getEditor().store.findExact('gradeName',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('gradeName',value)).data.gradeName;
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(!isNullOrEmpty(value) && value !== '') {
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('gradeName');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName;
    				}
    			}
    			else{
    				if(Ext.isDefined(record.get('minGrade')) && isNullOrEmpty(record.get('minGrade'))){
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    		}
    	}
	},{
		header : getCBTranslation('eval_seq_detail_maxGrade'),
		dataIndex : 'maxGrade',
		flex : 1,
		editor: {
    		xtype: 'customcombobox',
    		name: 'courseCutOffComboMax',
    		itemId: 'maxGradeId',
    		//store: Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationFormOneGrades'),
    		displayField: 'gradeName',
			valuefield:'gradeName',
			typeAhead : true,
    		forceSelection: true,
    		editable: false,
    		/*listeners: {
    			blur: function(combo, r) {
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().extraParams = {
    						leaveTypeNotInIDs: null
    					};
    				});
    				combo.getStore().load();
    			},
    			focus: function(combo, e, eOpts) {
    				//combo.lastQuery = null;
    				var me = this.up('leaveholidaycheckgrid');
    				combo.getStore().on('beforeload', function(){
    					this.getProxy().extraParams = {
    						leaveTypeNotInIDs: me.getAllSelectedLeaveTypeIds(combo)
    					};
    				});
    				combo.getStore().load();
    			}
    		}*/
    	},
    	listeners: {
			render: function(combo){
				var me = this;
				var managecoursesectionaddmappingtab = me.up('managecoursesectionaddmappingtab');
				if(!isNullOrEmpty(managecoursesectionaddmappingtab)){
					if(managecoursesectionaddmappingtab.config.gridRecord.length>0){
						var gridRec = managecoursesectionaddmappingtab.config.gridRecord[0];
						var courseGradeType = gridRec.data.courseGradeType;
						
						combo.getEditor().store.on('beforeload', function(){
	    					this.getProxy().extraParams = {
	    						gradeType: courseGradeType
	    					};
	    				});
						combo.getEditor().store.load();
					}
				}
			}
    	},
    	renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
    		if((isNullOrEmpty(record.get('id')) || record.get('id') == '') && !isNullOrEmpty(value)) {
    			try{
    				var index = rec.column.getEditor().store.findExact('gradeName',value);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('gradeName',value)).data.gradeName;
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(!isNullOrEmpty(value) && value !== '') {
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('gradeName');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName;
    				}
    			}
    			else{
    				if(Ext.isDefined(record.get('maxGrade')) && isNullOrEmpty(record.get('maxGrade'))){
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    		}
    	}
	},{
		header : getCourseTxCommonTranslation('CREDITS'),
		dataIndex : 'courseCredits',
		flex : 1,
		editor: {
			xtype: 'numberfield',
			itemId:'courseCredit_Id',
			name: 'courseCredits',
			minValue : 0,
			allowDecimals:true,
			decimalPrecision: 2
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if(Ext.isDefined(record.get('courseCredits')) && isNullOrEmpty(record.get('courseCredits'))){
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
			else{
				return value;
			}
    	}
	}],
	plugins: [{
		ptype: 'cellediting',
		clicksToEdit: 1,
		listeners: {
			beforeedit: function(obj, editor, context) {
				
			}
		}
	}],
});