/**
 * @author Rajkumar.Patidar
 */

Ext.define('Academia.view.coursetransaction.sectionmanagement.MapCourseVariantWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.mapcoursevariantwin',
	title:getCourseTxCommonTranslation('COURSE_VARIANT'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	width: 1030,
	maxHeight: 450,
	items: [{
		xtype: 'dynamicfieldformwin',
		itemId:'mapcoursevariantwinId',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit: false,
		items: [{
			xtype:'hidden',
			name:'id'
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype : 'customcombobox',
				name : 'academicTerm',
				itemId : 'academicTerm',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
				store : Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				valueField : 'id',
				displayField : 'value'
			},{
				
				xtype: 'customcombobox',
				name: 'program',
			    itemId:'programId',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				store:Ext.create('Academia.store.programCourseDashboard.ProgramsBySectionGroupIdStore'),
				displayField:'valueCode',
				valueField:'id',
				width:226,
				typeAhead:false,
				minChars:3,
				forceSelection:true,
				hidden:true,
				queryParam:'programName',
			    typeAhead:false,
				disabled : true,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                        '{value}' +
		                    '</div>';
		                }  
	            }
			},{
				xtype: 'customcombobox',
				name: 'batchId',
				fieldLabel: getCourseTxCommonTranslation('BATCH'),
				itemId:'batchId',
				hidden:true,
				store: Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionGroupBatchStore'),
				valueField: 'id',
				displayField: 'code',
				typeAhead:true,
				forceSelection:true,
				disabled : true
			},{
				xtype: 'customcombobox',
				name: 'periodId',
				itemId:'periodId',
				width:226,
				hidden:true,
				fieldLabel: getCourseTxCommonTranslation('PERIOD'),
				store: Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionGroupPeriodStore'),
				valueField: 'id',
				displayField: 'value',
				typeAhead:true,
				forceSelection:true,
				disabled : true
			}]
		},{
			xtype: 'panel',
			width: '100%',
			layout: 'vbox',
			itemId: 'mapCourseVariantFieldsPanel',
			style: {
				'margin': 0,
				'padding': 0
			},
			bodyStyle: {
				'margin': 0,
				'padding': 0
			},
			items:[]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});