/**
 * Rajkumar
 */

Ext.define('Academia.view.coursetransaction.sectionmanagement.ProgramBatchSectionWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.programbatchsectionwin',
	autoScroll: true,
	title:getCourseTxCommonTranslation('ADD_NEW_SECTION'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'dynamicfieldformwin',
		customFieldEntity:CONSTANTS.SECTION_CUSTOM_FIELD,
		bodyPadding: '5 5 5 5',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype: 'fieldcontainer',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			width:'auto',
			items : [{
				xtype: 'textfield',
				name: 'sectionCode',
				itemId:'sectionCode',
				fieldLabel: getCourseTxCommonTranslation('SECTION_NAME'),
			    allowBlank:false,
			    maxLength: 15, //255,
		    	enforceMaxLength : true,
		    	/*listeners: {
	                render : function(c) {
	                	c.inputEl.on('mouseover', function(ev, field){
	                		field.title = field.value;
	                	});
	                }
	            } */
			},{
				xtype: 'textfield',
				name: 'alternateName',
				itemId: 'alternateName',
				fieldLabel: getCourseTxCommonTranslation('PRINT_NAME'),
				maxLength: 25, //255,
				/*listeners: {
	                render : function(c) {
	                	c.inputEl.on('mouseover', function(ev, field){
	                		field.title = field.value;
	                	});
	                }
	            } */
			}]
		},{
			xtype: 'fieldcontainer',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			width:'auto',
			items : [{
				xtype: 'customcombobox',
				name: 'homeRoom',
				itemId: 'homeRoom',
				fieldLabel: getCourseTxCommonTranslation('ASSIGN_HOME_ROOM'),
				//store:'coursetransaction.sectionmanagement.AssignHomeRoomStore',
				store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoom',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				allowBlank:false,
				editable:true,
				queryMode:'local',
				typeAhead : false,
				anyMatch : true
			},{
				xtype: 'numberfield',
				name: 'maxCapacity',
				itemId: 'maxCapacity',
	  		    fieldLabel: getCourseTxCommonTranslation('CAPACITY'),
	  		    minValue:0,
	  		    maxValue : 5000,
	  		    hideTrigger:true,
				allowExponential:false,
				allowDecimals:false
			}]
		},{
			xtype: 'fieldcontainer',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			width:'auto',
			items : [{
				xtype: 'customcombobox',
				name: 'classTeacher',
				itemId: 'classTeacher',
				fieldLabel: getCourseTxCommonTranslation('ASSIGN_CLASS_TEACHER'),
				store:'coursetransaction.sectionmanagement.AssignClassTeacherSmartSearch',
				//store:'coursetransaction.sectionmanagement.AssignClassTeacherStore',
				displayField:'value',
				valueField:'id',
				queryParam:'nameOrCode',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
	            forceSelection:true,
	            allowBlank:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
			},{
				xtype: 'customcombobox',
				name: 'succedingSection',
				itemId: 'succedingSection',
				fieldLabel: getCourseTxCommonTranslation('SUCCEDING_SECTION'),
				store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.SuccedingSection',
				displayField:'value',
				valueField:'id',
				typeAhead:false,
				forceSelection:true,
				allowBlank:true
			}]
		},{
			xtype: 'fieldcontainer',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			width:'auto',
			items: [{
				xtype: 'multiselectcombofield',
				width: 460,
				name: 'multiselectAssessmentScheme',
				cls: 'multiselectAcademyLocation',
				itemId: 'multiselectAssessmentScheme',
				fieldLabel : getCommonTranslation('EVALUATION_PLAN'),
				store:'common.EvaluationPlanByPeriodStore',
				displayField:'value',
				valueField:'id',
				matchFieldWidth:true,
				queryMode:'local',
//				hidden: true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				}

			}]
		},{	
			xtype:'fieldcontainer',
			layout:'hbox',
			style:{
				marginLeft:'-03px'
			},
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'addSectionSubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'addSectionCancelBtn',
				scale: CONSTANTS.BUTTONSIZE

			}]
		}]
	}]     
});
