Ext.define('Academia.view.coursetransaction.studentcourseenrollment.enrollmenttabstructure.studentlist.CurrentlyEnrolledStudentList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias : 'widget.currentlyenrolledstudentlist',
    store : 'coursetransaction.studentenrollment.enrollmentmaster.CurrentlyEnrolledGrid',
    title : getCommonTranslation('LIST_OF_CURRENTLY_ENROLLED_STUDENT'),
    border: true,
    viewConfig : {
	stripeRows : CONSTANTS.STRIPEROWS
    },
    dockedItems : [{
    	xtype : 'toolbar',
    	dock : 'bottom',
    	items : [{
    		xtype: 'custompagingtoolbar',
    		plugins:['pagesize'],
    		store : 'coursetransaction.studentenrollment.enrollmentmaster.CurrentlyEnrolledGrid',
    		emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
    		displayInfo : true
    	}]
    }],
    initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
    }, 
    columns : [{
    	header : getCommonTranslation('STUDENT_ID'),
    	dataIndex : 'studentCode',
    	flex: .2,
    	sortable : true
    },{
    	header : getCourseTxCommonTranslation('ADMISSION_CODE'),
    	dataIndex : 'admissionCode',
    	flex : .2,
    	sortable : true
    },{
	    header : getCourseTxCommonTranslation('STUDENT_NAME'),
	    dataIndex : 'studentName',
	    flex : .3,
	    sortable : true
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : .3,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : .3,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : .3,
		hidden :true
	},{
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        sortable:true,
        flex: .3,
        hidden:true
    },{
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        sortable: true,
        flex: .3,
        hidden:true
    },{
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'periodName',
        sortable:true,
        flex: .3,
        hidden:true
    },{
	    header : getCourseTxCommonTranslation('SECTION'),
	    dataIndex : 'section',
	    flex : .3,
	    sortable : true
	},{
		header : getProgramandcourseTranslation('DATE_OF_ENROLLMENT'),
		dataIndex : 'enrolledDate',
		flex:.3,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	}]
});
 