Ext.define('Academia.view.coursetransaction.studentcourseenrollment.enrollmenttabstructure.studentlist.RequestRejectedStudentList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias : 'widget.requestrejectedstudentlist',
    store : 'coursetransaction.studentenrollment.enrollmentmaster.RequestRejectedGrid',
    title : getCommonTranslation('LIST_OF_REQUEST_REJECTED_STUDENT'),
    border: true,
    viewConfig : {
	stripeRows : CONSTANTS.STRIPEROWS
    },
    dockedItems : [{
    	xtype : 'toolbar',
    	dock : 'bottom',
    	items : [ {
    		xtype: 'custompagingtoolbar',
    		plugins:['pagesize'],
    		store : 'coursetransaction.studentenrollment.enrollmentmaster.RequestRejectedGrid',
    		emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
    		displayInfo : true
    	} ]
    }],
    initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
    }, 
    columns : [{
    	header : getCommonTranslation('STUDENT_ID'),
    	dataIndex : 'studentCode',
    	flex:1

    }, {
	    header : getCourseTxCommonTranslation('ADMISSION_CODE'),
	    dataIndex : 'admissionCode',
	    flex : 1,
	    sortable : true
	},{
	    header : getCourseTxCommonTranslation('STUDENT_NAME'),
	    dataIndex : 'studentName',
	    flex : 1,
	    sortable : true
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : 1,
		hidden :true
	},{
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        sortable:true,
	    flex : 1,
        hidden:true
    },{
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        sortable: true,
	    flex : 1,
        hidden:true
    },{
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'periodName',
        sortable:true,
	    flex : 1,
        hidden:true
    },{
	    header :getCourseTxCommonTranslation('REJECTION_REASON') ,
	    dataIndex : 'rejectionReason',
	    flex : 1,
	    sortable : true
	}  
	]

});
 