Ext.define('Academia.view.coursetransaction.studentcourseenrollment.studentcourseregistrationrevamp.CBSCourseUnenrollmentGrid',
		{
	extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.cbscourseunenrollmentgrid',
	store : 'coursetransaction.studentenrollment.enrollmentmaster.StudentCourseSectionStudentSearchStore',
	title : getProgramandcourseTranslation('LIST_OF_UNEROLLED_STUDENTS'),
	selType : 'checkboxmodel',
	selModel : {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	border : true,
	autoScroll : true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	initComponent : function() {
		var grid = this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins : [ 'pagesize' ],
			displayInfo : true,
			emptyMsg : getCommonTranslation('NORESULTSNMESSAGE'),
			store : 'coursetransaction.studentenrollment.enrollmentmaster.StudentCourseSectionStudentSearchStore',
		} ]
	} ],
	tbar : [ {
		xtype : 'button',
		itemId : 'btnCourseEnrollStudent',
		text : getProgramandcourseTranslation('ENROLL'),
		tooltip : getProgramandcourseTranslation('ENROLL'),
		disabled:true,
	}],
	columns : [{
		header : getCommonTranslation('STUDENT_CODE'),
		dataIndex : 'studentCode',
		sortable : true,
		flex : .1,
		renderer:function(value,meta,record){
			if(record.data.studentCode == 0){
				return record.data.studentCode ;
			} else {
				return '<a href=#>'+record.data.studentCode +'</a>'
			}
		}
	}, {
		header : getCommonTranslation('ADMISSION_CODE'),
		dataIndex : 'admissionCode',
		sortable : true,
		flex : .1
	}, {
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		sortable : true,
		flex : .1
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : .1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : .1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : .1,
		hidden :true
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'sectionCodePbs',
		sortable : true,
		flex : .1
	},{
		header : getProgramandcourseTranslation('EXAM_SCORE'),
		dataIndex : 'score',
		flex:.1,
		hidden :true
	},{
		header : getCommonTranslation('STUDENT_STATUS_CSM'),
		dataIndex: 'studentStatus',
		sortable: true,
		flex: .1,
		hidden: true,
		 renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			 rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
			 rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 15px;max-height: 60px;min-width: 16ch;max-width: 17ch;';
			 return val;
		 }
	}/*,{
		header : getCommonTranslation('COURSE_TYPE'),
		dataIndex : 'courseType',
		sortable : true,
		flex : .1
	}*/
	]
		});