/**
 *  @author Rajkumar.patidar
 */

 
Ext.define('Academia.view.coursetransaction.studymaterialdistribution.StudentGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.studentgrid',
	store : 'coursetransaction.studymaterialdistribution.StudentGridStore',
	border: true,
	selType:'checkboxmodel',
	autoScroll: true,
	viewConfig : {
		stripeRows : false
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'coursetransaction.studymaterialdistribution.StudentGridStore',
			emptyMsg :getCourseTxCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
    tbar: [{
    	 xtype: 'button',
         itemId: 'btnAdd',
         tooltip: getCourseTxCommonTranslation('ADD'),
         glyph: ICONGLYPH.ADDGLYPH
     }, {
         xtype: 'button',
         itemId: 'btnDelete',
         cls: 'CustomToolbarBtnReject',
         tooltip: getCourseTxCommonTranslation('DELETE'),
         glyph: ICONGLYPH.DELETEGLYPH
    },{
    	xtype : 'splitbutton',
  	    itemId:'spBtnMoreActions',
  	    text : getCourseTxCommonTranslation('MOREACTIONS'),
  	    menu:[{
  		    text:getCourseTxCommonTranslation('STUDY_MATERIAL_DISTRIBUTION_APPROVE'),
  		    itemId:'approveLinked'
  	        },{
  	    	text:getCourseTxCommonTranslation('MARK_AS_SENT'),
  	  		itemId:'markAsSentLinked'
  	    }]
    }],
	columns: [{
		hidden : true,
		dataIndex : 'id'
	},{
		header : getCourseTxCommonTranslation('ADMISSION_CODE'),
		dataIndex : 'admission',
		flex:0.2,
		renderer : function(value){
			if(value!=null){
			  return value.value;
			}
		}
	},{
		header : getCourseTxCommonTranslation('STUDENT_NAME'),
		dataIndex : 'student',
		flex:0.4,
		renderer : function(value){
			if(value!=null){
				  return value.value;
				}
		}
	},{
		header : getCourseTxCommonTranslation('SENT_SEQUENCE'),
		dataIndex : 'sentSequence',
		flex:0.1
	},{
		header : getCourseTxCommonTranslation('SENDER_STATUS'),
		dataIndex : 'sendingStatus',
		flex:0.1,
		renderer : function(value){
			if(value=='SENT' || value=='Sent'){
			  return '<a href="#">' + 'Sent' +'</a>';
			}else if(value == 'Returned' || value == 'RETURNED' || value == 'Resent'){
				return '<a href="#">' + 'Returned' +'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getCourseTxCommonTranslation('RECIEVER_STATUS'),
		dataIndex : 'recivingStatus',
		flex:0.1
	},{
		header : getCourseTxCommonTranslation('APPROVED_STATUS'),
		dataIndex : 'autoApprovedStatus',
		flex:0.2,
		renderer : function(value){
			if(value){
				return getCourseTxCommonTranslation('APPROVED');
			}else{
				return getCourseTxCommonTranslation('NOT_APPROVED');
			}
		}
	}]
});