Ext.define('Academia.view.dashboard.dashlets.AdmissionCountDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.admissioncountdashlet',
    graphView:false,
    layout:'card',
    activeItem: 1, 
    autoScroll:false,
    cls:'AdmissionCountDashletCLS dashlet horizontalScrollingFixed',
	loadDashlet :function(paramObj){ 
	    var this$=this;
	    var view= this.layout.getActiveItem();
	    
	    try{
	    	var previousTabNo = Ext.ComponentQuery.query('admissioncountdashlet')[0].activeTab.toString().replace(',7','');
	    }
	    catch(e){
	    	var previousTabNo = '';
	    }
	    
	    var toolbar;
		var dates;
		if(this.up('dashboardhomepage') == undefined){
			dates={
					startDate:Ext.ComponentQuery.query('extendeddatefilter[itemId=dateRangePicker]')[0].startDate,
					endDate:Ext.ComponentQuery.query('extendeddatefilter[itemId=dateRangePicker]')[0].endDate
			};
			var tempStartDate=new Date(dates.startDate);
			var tempEndDate=new Date(dates.endDate);
			dates.startDate=tempStartDate.getFullYear()+'-'+(tempStartDate.getMonth()+1)+'-'+tempStartDate.getDate();
			dates.endDate=tempEndDate.getFullYear()+'-'+(tempEndDate.getMonth()+1)+'-'+tempEndDate.getDate();
		}else{
			toolbar = this$.up('dashboardhomepage').down('toolbar');
			//dates=toolbar.down('#dateRangePicker').getValues();
			dates={
					startDate:toolbar.down('#dateRangePicker').startDate,
					endDate:toolbar.down('#dateRangePicker').endDate
			};
			var tempStartDate=new Date(dates.startDate);
			var tempEndDate=new Date(dates.endDate);
			dates.startDate=tempStartDate.getFullYear()+'-'+(tempStartDate.getMonth()+1)+'-'+tempStartDate.getDate();
			dates.endDate=tempEndDate.getFullYear()+'-'+(tempEndDate.getMonth()+1)+'-'+tempEndDate.getDate();
		}
	    
	    if(view.xtype=='griddashlet' || view.xtype=='columnchartdashlet'){
	    	var store= view.getStore();
	    	var extraparams;
			if(paramObj !=undefined){
				extraparams=paramObj;
				//extraparams['intakeYearId']="";
				extraparams['academyId']=null;
				extraparams['batchId']=null;
				extraparams['locationId']=null;
				extraparams['programId']=null;
				extraparams['seatTypeId']=null;
			}else{
				extraparams=this$.getParams();
			}
			
			if(this$.getParams()!=undefined){
				/*extraparams['intakeYearId']=this$.getParams().intakeYearId;
				extraparams['academyId']=this$.getParams().academyId;
				extraparams['batchId']=this$.getParams().batchId;
				extraparams['locationId']=this$.getParams().locationId;
				extraparams['programId']=this$.getParams().programId;
				extraparams['seatTypeId']=this$.getParams().seatTypeId;*/
				
				//extraparams['intakeYearId']="";
				extraparams['academyId']=null;
				extraparams['batchId']=null;
				extraparams['locationId']=null;
				extraparams['programId']=null;
				extraparams['seatTypeId']=null;
			}
			
			switch (view.itemId) {
				case 'programCategoryItem_ADM':{
					store.getProxy().extraParams = {
						startDate:dates.startDate,
						endDate:dates.endDate
					};
					break;
				}
				case 'programGroupItem_ADM': {
					store.getProxy().extraParams = {
						startDate:dates.startDate,
						endDate:dates.endDate
					};
					break;
				}
				case 'programBatchItem_ADM': {
					store.getProxy().extraParams = {
						startDate:dates.startDate,
						endDate:dates.endDate
					};
					break;
				}
				case 'programCategoryGenderItem_ADM': {
					store.getProxy().extraParams = {
						startDate:dates.startDate,
						endDate:dates.endDate
					};
					break;
				}
				case 'programGroupGenderItem_ADM': {
					store.getProxy().extraParams = {
						startDate:dates.startDate,
						endDate:dates.endDate
					};
					break;
				}
				case 'programBatchGenderItem_ADM': {
					store.getProxy().extraParams = {
						startDate:dates.startDate,
						endDate:dates.endDate
					};
					break;
				}
				case 'academicLocationInnerItem_ADM': {
					store.getProxy().extraParams = {
						startDate:dates.startDate,
						endDate:dates.endDate,
						programCategoryId: Ext.isDefined(extraparams.programCategoryId) ? extraparams.programCategoryId : store.getProxy().extraParams.programCategoryId,
						seatType1Id: extraparams.seatType1Id,
						status: extraparams.status,
						acadmyLocationId:  extraparams.acadmyLocationId,
						genderCSM: Ext.isDefined(extraparams.genderCSM) ? extraparams.genderCSM : store.getProxy().extraParams.genderCSM,
						genderId: Ext.isDefined(extraparams.genderId) ? extraparams.genderId : store.getProxy().extraParams.genderId,
						programGroupId: Ext.isDefined(extraparams.programGroupId) ? extraparams.programGroupId : store.getProxy().extraParams.programGroupId,
						batch1Id: extraparams.batch1Id,
						program1Id: extraparams.program1Id,
						academyId: extraparams.academyId,
						batchId: extraparams.batchId,
						intakeYearId: extraparams.intakeYearId,
						locationId: extraparams.locationId,
						programId: extraparams.programId,
						seatTypeId: extraparams.seatTypeId
					};
					if((Ext.isDefined(paramObj) && Ext.isDefined(paramObj.programGroupId)) || (previousTabNo=="2")){
						store.getProxy().extraParams.programCategoryId = null;
					}
					else if(previousTabNo!="2"){
						store.getProxy().extraParams.programGroupId = null;
					}
					break;
				}
				case 'studentListInnerItem_ADM': {
					store.getProxy().extraParams = {
						startDate:dates.startDate,
						endDate:dates.endDate,
						programCategoryId: extraparams.programCategoryId,
						seatType1Id: extraparams.seatType1Id,
						status: extraparams.status,
						acadmyLocationId:  extraparams.acadmyLocationId,
						genderCSM: Ext.isDefined(extraparams.genderCSM) ? extraparams.genderCSM : store.getProxy().extraParams.genderCSM,
						genderId: Ext.isDefined(extraparams.genderId) ? extraparams.genderId : store.getProxy().extraParams.genderId,
						programGroupId: extraparams.programGroupId,
						batch1Id: extraparams.batch1Id,
						program1Id: extraparams.program1Id,
						academyId: extraparams.academyId,
						batchId: extraparams.batchId,
						intakeYearId: extraparams.intakeYearId,
						locationId: extraparams.locationId,
						programId: extraparams.programId,
						seatTypeId: extraparams.seatTypeId
					};
					break;
				}
				case 'programBatchItemWOAL_ADM': {
					store.getProxy().extraParams = {
						startDate:dates.startDate,
						endDate:dates.endDate,
						programCategoryId: Ext.isDefined(extraparams.programCategoryId)?extraparams.programCategoryId:store.getProxy().extraParams.programCategoryId,
						seatType1Id: extraparams.seatType1Id,
						status: extraparams.status,
						acadmyLocationId:  Ext.isDefined(extraparams.acadmyLocationId)?extraparams.acadmyLocationId:store.getProxy().extraParams.acadmyLocationId,
						genderCSM: Ext.isDefined(extraparams.genderCSM) ? extraparams.genderCSM : store.getProxy().extraParams.genderCSM,
						genderId: Ext.isDefined(extraparams.genderId) ? extraparams.genderId : store.getProxy().extraParams.genderId,
						programGroupId: Ext.isDefined(extraparams.programGroupId) ? extraparams.programGroupId : store.getProxy().extraParams.programGroupId,
						batch1Id: extraparams.batch1Id,
						program1Id: extraparams.program1Id,
						academyId: extraparams.academyId,
						batchId: extraparams.batchId,
						intakeYearId: extraparams.intakeYearId,
						locationId: extraparams.locationId,
						programId: extraparams.programId,
						seatTypeId: extraparams.seatTypeId
					};
					if((Ext.isDefined(paramObj) && Ext.isDefined(paramObj.programGroupId) && !isNullOrEmpty(paramObj.programGroupId)) || (previousTabNo=="2,9")){
						store.getProxy().extraParams.programCategoryId = null;
					}
					else if(previousTabNo!="2,9"){
						store.getProxy().extraParams.programGroupId = null;
					}
					break;
				}
				case 'academicLocationInnerItem_GEN_ADM': {
					store.getProxy().extraParams = {
						startDate:dates.startDate,
						endDate:dates.endDate,
						//programCategoryId: extraparams.programCategoryId,
						programCategoryId: Ext.isDefined(extraparams.programCategoryId) ? extraparams.programCategoryId : store.getProxy().extraParams.programCategoryId,
						seatType1Id: extraparams.seatType1Id,
						status: extraparams.status,
						acadmyLocationId:  extraparams.acadmyLocationId,
						//gender: extraparams.gender,
						genderCSM: Ext.isDefined(extraparams.genderCSM) ? extraparams.genderCSM : store.getProxy().extraParams.genderCSM,
						genderId: Ext.isDefined(extraparams.genderId) ? extraparams.genderId : store.getProxy().extraParams.genderId,
						programGroupId: Ext.isDefined(extraparams.programGroupId) ? extraparams.programGroupId : store.getProxy().extraParams.programGroupId,
						batch1Id: extraparams.batch1Id,
						program1Id: extraparams.program1Id,
						academyId: extraparams.academyId,
						batchId: extraparams.batchId,
						intakeYearId: extraparams.intakeYearId,
						locationId: extraparams.locationId,
						programId: extraparams.programId,
						seatTypeId: extraparams.seatTypeId
					};
					if((Ext.isDefined(paramObj) && Ext.isDefined(paramObj.programGroupId) && !isNullOrEmpty(paramObj.programGroupId)) || (previousTabNo=="2")){
						store.getProxy().extraParams.programCategoryId = null;
					}
					else if(previousTabNo!="2" && previousTabNo!="5,10"){
						store.getProxy().extraParams.programGroupId = null;
					}
					break;
				}
				case 'studentListInnerItem_GEN_ADM': {
					store.getProxy().extraParams = {
						startDate:dates.startDate,
						endDate:dates.endDate,
						programCategoryId: extraparams.programCategoryId,
						seatType1Id: extraparams.seatType1Id,
						status: extraparams.status,
						acadmyLocationId:  extraparams.acadmyLocationId,
						genderCSM: Ext.isDefined(extraparams.genderCSM) ? extraparams.genderCSM : store.getProxy().extraParams.genderCSM,
						genderId: Ext.isDefined(extraparams.genderId) ? extraparams.genderId : store.getProxy().extraParams.genderId,
						programGroupId: extraparams.programGroupId,
						batch1Id: extraparams.batch1Id,
						program1Id: extraparams.program1Id,
						academyId: extraparams.academyId,
						batchId: extraparams.batchId,
						intakeYearId: extraparams.intakeYearId,
						locationId: extraparams.locationId,
						programId: extraparams.programId,
						seatTypeId: extraparams.seatTypeId
					};
					break;
				}
				case 'programBatchItemWOAL_GEN_ADM': {
					store.getProxy().extraParams = {
						startDate:dates.startDate,
						endDate:dates.endDate,
						//programCategoryId: extraparams.programCategoryId,
						programCategoryId: Ext.isDefined(extraparams.programCategoryId)?extraparams.programCategoryId:store.getProxy().extraParams.programCategoryId,
						seatType1Id: extraparams.seatType1Id,
						status: extraparams.status,
						//acadmyLocationId:  extraparams.acadmyLocationId,
						acadmyLocationId:  Ext.isDefined(extraparams.acadmyLocationId)?extraparams.acadmyLocationId:store.getProxy().extraParams.acadmyLocationId,
						//gender: extraparams.gender,
						genderCSM: Ext.isDefined(extraparams.genderCSM) ? extraparams.genderCSM : store.getProxy().extraParams.genderCSM,
						genderId: Ext.isDefined(extraparams.genderId) ? extraparams.genderId : store.getProxy().extraParams.genderId,
						programGroupId: Ext.isDefined(extraparams.programGroupId)?extraparams.programGroupId:store.getProxy().extraParams.programGroupId,
						//programGroupId: extraparams.programGroupId,
						batch1Id: extraparams.batch1Id,
						program1Id: extraparams.program1Id,
						academyId: extraparams.academyId,
						batchId: extraparams.batchId,
						intakeYearId: extraparams.intakeYearId,
						locationId: extraparams.locationId,
						programId: extraparams.programId,
						seatTypeId: extraparams.seatTypeId
					};
					break;
				}
			}
			this$.resetPageSetting(store);
	    	store.load({params:extraparams,
	    		callback: function(rec, operation, success) {
	    			if(isNullOrEmpty(rec.length) || rec.length==0){
	    				this$.layout.setActiveItem(0);
	    			}
	    		}
	    	});
	    }
	    else if(view.xtype=='panel'){
	    	this.layout.setActiveItem(1);
	    	var view1=this.layout.getActiveItem();
	    	var store= view1.getStore();
	    	var extraparams=this$.getParams();
	    	store.load({params:extraparams,
	    		callback: function(rec, operation, success) {
	    			if(rec.length==0){
	    				this$.layout.setActiveItem(0);
	    			}
	    		}
	    	});
	    }
		
	},
	defaults: {
		cls:'panelNoSpace',
		xtype:'griddashlet'
    },
    
	items:[{
		xtype: 'panel',
		width: '100%',
		height: '100%',
		//src: CONSTANTS.NO_DATA_DISPALY_DASHBORD_IMAGE_SRC,//'resources/images/no_data_to_display.png',
		html: '<div><div class ="dashletNoRecordFoundImageCls" /><span>'+getCommonTranslation('EMPTY_MESSAGE')+'</span></div>',
		listeners:{
			activate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				Ext.each(admissioncountdashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						admissioncountdashlet.getHeader().remove(currentHeaderTool);
					}
				});
				admissioncountdashlet.activeTab = 0;
				
				admissioncountdashlet.addForProgramCategory_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroup_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatch_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);
				
				//admissioncountdashlet.addGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.addExportToPdf(admissioncountdashlet,portlet);
				admissioncountdashlet.addExportToExcel(admissioncountdashlet,portlet);
			},
			deactivate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				//admissioncountdashlet.removeGraphViewButton(admissioncountdashlet);
				
				admissioncountdashlet.removeProgramGroup_ADM();
				admissioncountdashlet.removeProgramBatch_ADM();
				admissioncountdashlet.removeProgramCategory_ADM();
				admissioncountdashlet.removeProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);
				
				admissioncountdashlet.removeExportToPdf();
				admissioncountdashlet.removeExportToExcel();
			}
		}
	},
	{
		xtype:'griddashlet',
		itemId:'programCategoryItem_ADM',
		title:getCommonTranslation('ADMISSION_COUNT'),
		header:false,
		model:'Academia.model.admission.AdmissionTallyDashletModel', //need to change this
		url : SERVERURL.COUNT_ADMISSION_PROGRAM_CATEGORY, //need to change this
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('PROGRAM_CATEGORY'),
			dataIndex : 'programCategoryName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('SEAT_TYPE'),
			dataIndex : 'seatType',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('CONFIRMED_ADMISSION'),
			dataIndex : 'confirmedCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TRIAL_ADMISSION'),
			dataIndex : 'trialCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('PROVISIONAL_ADMISSION'),
			dataIndex : 'provisionalCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TOTAL_ADMISSIONS'),
			dataIndex : 'totalAdmission',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			header : getCommonTranslation('PERCENTAGE_SEATS_FILLED'),
			dataIndex : 'percentageSeatsFilled',
			//flex : .2,
			sortable : true,
			renderer:function(value, rec){
				return value+'%';
			}
		}],
		listeners:{
			activate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				Ext.each(admissioncountdashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						admissioncountdashlet.getHeader().remove(currentHeaderTool);
					}
				});
				admissioncountdashlet.activeTab = 1;
				
				admissioncountdashlet.addForProgramGroup_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatch_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.addGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.addExportToPdf(admissioncountdashlet,portlet);
				admissioncountdashlet.addExportToExcel(admissioncountdashlet,portlet);
			},
			deactivate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				
				admissioncountdashlet.removeProgramGroup_ADM();
				admissioncountdashlet.removeProgramBatch_ADM();
				admissioncountdashlet.removeProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.removeGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.removeExportToPdf();
				admissioncountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var admissionCountGrid = cell.up('grid');
					var columnName = admissionCountGrid.columnManager.columns[cellIndex].dataIndex;

					var selectedRecord = admissionCountGrid.getSelectionModel().getSelection()[0];
					var admissioncountdashlet=admissionCountGrid.up('admissioncountdashlet');
					if(columnName == 'programCategoryName'){
						admissioncountdashlet.getLayout().setActiveItem(7);
						admissioncountdashlet.params={
								programCategoryId:selectedRecord.data.programCategoryId,
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programCategoryId:selectedRecord.data.programCategoryId,
								seatType1Id:selectedRecord.data.seatType1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'confirmedCount') {
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								programCategoryId:selectedRecord.data.programCategoryId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programCategoryId:selectedRecord.data.programCategoryId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'trialCount'){
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								programCategoryId:selectedRecord.data.programCategoryId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programCategoryId:selectedRecord.data.programCategoryId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'provisionalCount'){
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								programCategoryId:selectedRecord.data.programCategoryId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programCategoryId:selectedRecord.data.programCategoryId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'totalAdmission'){
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								programCategoryId:selectedRecord.data.programCategoryId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programCategoryId:selectedRecord.data.programCategoryId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id
						};	
						admissioncountdashlet.loadDashlet(paramsObj);
					}
					admissionCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'programGroupItem_ADM',
		title:getCommonTranslation('ADMISSION_COUNT'),
		header:false,
		model:'Academia.model.admission.AdmissionTallyDashletModel', //need to change this
		url : SERVERURL.COUNT_ADMISSION_PROGRAM_GROUP, //need to change this
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('PROGRAM_GROUP'),
			dataIndex : 'programGroupName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('SEAT_TYPE'),
			dataIndex : 'seatType',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('CONFIRMED_ADMISSION'),
			dataIndex : 'confirmedCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TRIAL_ADMISSION'),
			dataIndex : 'trialCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('PROVISIONAL_ADMISSION'),
			dataIndex : 'provisionalCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TOTAL_ADMISSIONS'),
			dataIndex : 'totalAdmission',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			header : getCommonTranslation('PERCENTAGE_SEATS_FILLED'),
			dataIndex : 'percentageSeatsFilled',
			//flex : .2,
			sortable : true,
			renderer:function(value, rec){
				return value+'%';
			}
		}],
		listeners:{
			activate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				Ext.each(admissioncountdashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						admissioncountdashlet.getHeader().remove(currentHeaderTool);
					}
				});
				admissioncountdashlet.activeTab = 2;
				
				admissioncountdashlet.addForProgramCategory_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatch_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.addGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.addExportToPdf(admissioncountdashlet,portlet);
				admissioncountdashlet.addExportToExcel(admissioncountdashlet,portlet);
			},
			deactivate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				
				admissioncountdashlet.removeProgramCategory_ADM();
				admissioncountdashlet.removeProgramBatch_ADM();
				admissioncountdashlet.removeProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.removeGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.removeExportToPdf();
				admissioncountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var admissionCountGrid = cell.up('grid');
					var columnName = admissionCountGrid.columnManager.columns[cellIndex].dataIndex;

					var selectedRecord = admissionCountGrid.getSelectionModel().getSelection()[0];
					var admissioncountdashlet=admissionCountGrid.up('admissioncountdashlet');
					if(columnName == 'programGroupName'){
						admissioncountdashlet.getLayout().setActiveItem(7);
						admissioncountdashlet.params={
								programGroupId:selectedRecord.data.programGroupId,
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programGroupId:selectedRecord.data.programGroupId,
								seatType1Id:selectedRecord.data.seatType1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'confirmedCount') {
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								programGroupId:selectedRecord.data.programGroupId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programGroupId:selectedRecord.data.programGroupId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'trialCount'){
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								programGroupId:selectedRecord.data.programGroupId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programGroupId:selectedRecord.data.programGroupId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'provisionalCount'){
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								programGroupId:selectedRecord.data.programGroupId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programGroupId:selectedRecord.data.programGroupId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'totalAdmission'){
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								programGroupId:selectedRecord.data.programGroupId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programGroupId:selectedRecord.data.programGroupId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id
						};	
						admissioncountdashlet.loadDashlet(paramsObj);
					}
					admissionCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},
	{
		xtype:'griddashlet',
		itemId:'programBatchItem_ADM',
		title:getCommonTranslation('ADMISSION_COUNT'),
		header:false,
		model:'Academia.model.admission.AdmissionTallyDashletModel', //need to change this
		url : SERVERURL.COUNT_ADMISSION_PROGRAM_BATCH, //need to change this
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('ACADEMY_LOCATION'),
			dataIndex : 'academyLocationName',
			sortable : true,
			flex:0.1
		},{
			text : getCommonTranslation('PROGRAM'),
			dataIndex : 'programName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('BATCH'),
			dataIndex : 'batchName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('SEAT_TYPE'),
			dataIndex : 'seatType',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('CONFIRMED_ADMISSION'),
			dataIndex : 'confirmedCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TRIAL_ADMISSION'),
			dataIndex : 'trialCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('PROVISIONAL_ADMISSION'),
			dataIndex : 'provisionalCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TOTAL_ADMISSIONS'),
			dataIndex : 'totalAdmission',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			header : getCommonTranslation('PERCENTAGE_SEATS_FILLED'),
			dataIndex : 'percentageSeatsFilled',
			//flex : .2,
			sortable : true,
			renderer:function(value, rec){
				return value+'%';
			}
		}],
		listeners:{
			activate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				Ext.each(admissioncountdashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						admissioncountdashlet.getHeader().remove(currentHeaderTool);
					}
				});
				admissioncountdashlet.activeTab = 3;
				
				admissioncountdashlet.addForProgramCategory_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroup_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.addGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.addExportToPdf(admissioncountdashlet,portlet);
				admissioncountdashlet.addExportToExcel(admissioncountdashlet,portlet);
			},
			deactivate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				
				admissioncountdashlet.removeProgramCategory_ADM();
				admissioncountdashlet.removeProgramGroup_ADM();
				admissioncountdashlet.removeProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.removeGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.removeExportToPdf();
				admissioncountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var admissionCountGrid = cell.up('grid');
					var columnName = admissionCountGrid.columnManager.columns[cellIndex].dataIndex;

					var selectedRecord = admissionCountGrid.getSelectionModel().getSelection()[0];
					var admissioncountdashlet=admissionCountGrid.up('admissioncountdashlet');
					if(columnName == 'confirmedCount') {
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id,
								batch1Id:selectedRecord.data.batch1Id
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id,
								batch1Id:selectedRecord.data.batch1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'trialCount'){
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								batch1Id:selectedRecord.data.batch1Id
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								batch1Id:selectedRecord.data.batch1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'provisionalCount'){
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								batch1Id:selectedRecord.data.batch1Id
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								batch1Id:selectedRecord.data.batch1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'totalAdmission'){
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id,
								batch1Id:selectedRecord.data.batch1Id
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id,
								batch1Id:selectedRecord.data.batch1Id
						};	
						admissioncountdashlet.loadDashlet(paramsObj);
					}
					admissionCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},
	{
		xtype:'griddashlet',
		itemId:'programCategoryGenderItem_ADM',
		title:getCommonTranslation('ADMISSION_COUNT'),
		header:false,
		model:'Academia.model.admission.AdmissionTallyDashletModel', //need to change this
		url : SERVERURL.COUNT_ADMISSION_PROGRAM_CATEGORY_GENDER_WISE, //need to change this
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('PROGRAM_CATEGORY'),
			dataIndex : 'programCategoryName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('GENDER'),
			dataIndex : 'genderCSM',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value=getCommonTranslation(value);
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('SEAT_TYPE'),
			dataIndex : 'seatType',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('CONFIRMED_ADMISSION'),
			dataIndex : 'confirmedCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TRIAL_ADMISSION'),
			dataIndex : 'trialCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('PROVISIONAL_ADMISSION'),
			dataIndex : 'provisionalCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TOTAL_ADMISSIONS'),
			dataIndex : 'totalAdmission',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			header : getCommonTranslation('PERCENTAGE_SEATS_FILLED'),
			dataIndex : 'percentageSeatsFilled',
			//flex : .2,
			sortable : true,
			renderer:function(value, rec){
				return value+'%';
			}
		}],
		listeners:{
			activate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				Ext.each(admissioncountdashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						admissioncountdashlet.getHeader().remove(currentHeaderTool);
					}
				});
				admissioncountdashlet.activeTab = 4;
				
				admissioncountdashlet.addForProgramCategory_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroup_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatch_ADM(admissioncountdashlet,portlet);
				//admissioncountdashlet.addForProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.addGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.addExportToPdf(admissioncountdashlet,portlet);
				admissioncountdashlet.addExportToExcel(admissioncountdashlet,portlet);
			},
			deactivate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				
				admissioncountdashlet.removeProgramCategory_ADM();
				admissioncountdashlet.removeProgramGroup_ADM();
				admissioncountdashlet.removeProgramBatch_ADM();
				//admissioncountdashlet.removeProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.removeGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.removeExportToPdf();
				admissioncountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var admissionCountGrid = cell.up('grid');
					var columnName = admissionCountGrid.columnManager.columns[cellIndex].dataIndex;

					var selectedRecord = admissionCountGrid.getSelectionModel().getSelection()[0];
					var admissioncountdashlet=admissionCountGrid.up('admissioncountdashlet');
					if(columnName == 'programCategoryName'){
						admissioncountdashlet.getLayout().setActiveItem(10);
						admissioncountdashlet.params={
								programCategoryId:selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programCategoryId:selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								seatType1Id:selectedRecord.data.seatType1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'confirmedCount') {
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								programCategoryId:selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programCategoryId:selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'trialCount'){
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								programCategoryId:selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programCategoryId:selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'provisionalCount'){
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								programCategoryId:selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programCategoryId:selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'totalAdmission'){
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								programCategoryId:selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programCategoryId:selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id
						};	
						admissioncountdashlet.loadDashlet(paramsObj);
					}
					admissionCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},
	{
		xtype:'griddashlet',
		itemId:'programGroupGenderItem_ADM',
		title:getCommonTranslation('ADMISSION_COUNT'),
		header:false,
		model:'Academia.model.admission.AdmissionTallyDashletModel', //need to change this
		url : SERVERURL.COUNT_ADMISSION_PROGRAM_GROUP_GENDER_WISE, //need to change this
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('PROGRAM_GROUP'),
			dataIndex : 'programGroupName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('GENDER'),
			dataIndex : 'genderCSM',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value=getCommonTranslation(value);
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('SEAT_TYPE'),
			dataIndex : 'seatType',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('CONFIRMED_ADMISSION'),
			dataIndex : 'confirmedCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TRIAL_ADMISSION'),
			dataIndex : 'trialCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('PROVISIONAL_ADMISSION'),
			dataIndex : 'provisionalCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TOTAL_ADMISSIONS'),
			dataIndex : 'totalAdmission',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			header : getCommonTranslation('PERCENTAGE_SEATS_FILLED'),
			dataIndex : 'percentageSeatsFilled',
			//flex : .2,
			sortable : true,
			renderer:function(value, rec){
				return value+'%';
			}
		}],
		listeners:{
			activate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				Ext.each(admissioncountdashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						admissioncountdashlet.getHeader().remove(currentHeaderTool);
					}
				});
				admissioncountdashlet.activeTab = 5;
				
				admissioncountdashlet.addForProgramCategory_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroup_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatch_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				//admissioncountdashlet.addForProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.addGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.addExportToPdf(admissioncountdashlet,portlet);
				admissioncountdashlet.addExportToExcel(admissioncountdashlet,portlet);
			},
			deactivate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				
				admissioncountdashlet.removeProgramCategory_ADM();
				admissioncountdashlet.removeProgramGroup_ADM();
				admissioncountdashlet.removeProgramBatch_ADM();
				admissioncountdashlet.removeProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				//admissioncountdashlet.removeProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.removeGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.removeExportToPdf();
				admissioncountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var admissionCountGrid = cell.up('grid');
					var columnName = admissionCountGrid.columnManager.columns[cellIndex].dataIndex;

					var selectedRecord = admissionCountGrid.getSelectionModel().getSelection()[0];
					var admissioncountdashlet=admissionCountGrid.up('admissioncountdashlet');
					if(columnName == 'programGroupName'){
						admissioncountdashlet.getLayout().setActiveItem(10);
						admissioncountdashlet.params={
								programGroupId:selectedRecord.data.programGroupId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programGroupId:selectedRecord.data.programGroupId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								seatType1Id:selectedRecord.data.seatType1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'confirmedCount') {
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								programGroupId:selectedRecord.data.programGroupId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programGroupId:selectedRecord.data.programGroupId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'trialCount'){
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								programGroupId:selectedRecord.data.programGroupId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programGroupId:selectedRecord.data.programGroupId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'provisionalCount'){
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								programGroupId:selectedRecord.data.programGroupId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programGroupId:selectedRecord.data.programGroupId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'totalAdmission'){
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								programGroupId:selectedRecord.data.programGroupId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id
						};
						var paramsObj={
								programGroupId:selectedRecord.data.programGroupId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id
						};	
						admissioncountdashlet.loadDashlet(paramsObj);
					}
					admissionCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},
	{
		xtype:'griddashlet',
		itemId:'programBatchGenderItem_ADM',
		title:getCommonTranslation('ADMISSION_COUNT'),
		header:false,
		model:'Academia.model.admission.AdmissionTallyDashletModel', //need to change this
		url : SERVERURL.COUNT_ADMISSION_PROGRAM_BATCH_GENDER_WISE, //need to change this
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('ACADEMY_LOCATION'),
			dataIndex : 'academyLocationName',
			sortable : true,
			flex:0.1
		},{
			text : getCommonTranslation('PROGRAM'),
			dataIndex : 'programName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('BATCH'),
			dataIndex : 'batchName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('GENDER'),
			dataIndex : 'genderCSM',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value=getCommonTranslation(value);
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('SEAT_TYPE'),
			dataIndex : 'seatType',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('CONFIRMED_ADMISSION'),
			dataIndex : 'confirmedCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TRIAL_ADMISSION'),
			dataIndex : 'trialCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('PROVISIONAL_ADMISSION'),
			dataIndex : 'provisionalCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TOTAL_ADMISSIONS'),
			dataIndex : 'totalAdmission',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			header : getCommonTranslation('PERCENTAGE_SEATS_FILLED'),
			dataIndex : 'percentageSeatsFilled',
			//flex : .2,
			sortable : true,
			renderer:function(value, rec){
				return value+'%';
			}
		}],
		listeners:{
			activate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				Ext.each(admissioncountdashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						admissioncountdashlet.getHeader().remove(currentHeaderTool);
					}
				});
				admissioncountdashlet.activeTab = 6;
				
				admissioncountdashlet.addForProgramCategory_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroup_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatch_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				//admissioncountdashlet.addForProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.addGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.addExportToPdf(admissioncountdashlet,portlet);
				admissioncountdashlet.addExportToExcel(admissioncountdashlet,portlet);
			},
			deactivate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				
				admissioncountdashlet.removeProgramCategory_ADM();
				admissioncountdashlet.removeProgramGroup_ADM();
				admissioncountdashlet.removeProgramBatch_ADM();
				admissioncountdashlet.removeProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				//admissioncountdashlet.removeProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.removeGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.removeExportToPdf();
				admissioncountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var admissionCountGrid = cell.up('grid');
					var columnName = admissionCountGrid.columnManager.columns[cellIndex].dataIndex;

					var selectedRecord = admissionCountGrid.getSelectionModel().getSelection()[0];
					var admissioncountdashlet=admissionCountGrid.up('admissioncountdashlet');
					if(columnName == 'confirmedCount') {
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id,
								batch1Id: selectedRecord.data.batch1Id
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id,
								batch1Id: selectedRecord.data.batch1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'trialCount'){
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								batch1Id: selectedRecord.data.batch1Id
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								batch1Id: selectedRecord.data.batch1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'provisionalCount'){
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								batch1Id: selectedRecord.data.batch1Id
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								batch1Id: selectedRecord.data.batch1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'totalAdmission'){
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id,
								batch1Id: selectedRecord.data.batch1Id
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id,
								batch1Id: selectedRecord.data.batch1Id
						};	
						admissioncountdashlet.loadDashlet(paramsObj);
					}
					admissionCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},
	{
		xtype:'griddashlet',
		itemId:'academicLocationInnerItem_ADM',
		title:getCommonTranslation('ADMISSION_COUNT'),
		header:false,
		model:'Academia.model.admission.AdmissionTallyDashletModel', //need to change this
		url : SERVERURL.COUNT_ADMISSION_ACADEMY_LOCATION_WISE, //need to change this
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('ACADEMY_LOCATION'),
			dataIndex : 'academyLocationName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('SEAT_TYPE'),
			dataIndex : 'seatType',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('CONFIRMED_ADMISSION'),
			dataIndex : 'confirmedCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TRIAL_ADMISSION'),
			dataIndex : 'trialCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('PROVISIONAL_ADMISSION'),
			dataIndex : 'provisionalCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TOTAL_ADMISSIONS'),
			dataIndex : 'totalAdmission',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			header : getCommonTranslation('PERCENTAGE_SEATS_FILLED'),
			dataIndex : 'percentageSeatsFilled',
			//flex : .2,
			sortable : true,
			renderer:function(value, rec){
				return value+'%';
			}
		}],
		listeners:{
			activate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');

				var previousBtnTab = admissioncountdashlet.activeTab.toString().split(',')[0];
				admissioncountdashlet.addTool(Ext.create('Ext.panel.Tool',{
					type: 'prev',
					handler: function(btn, target, header, tool){
						header.ownerCt.getLayout().setActiveItem(parseInt(previousBtnTab));
						header.remove(tool);
						admissioncountdashlet.params={};
						admissioncountdashlet.activeTab = admissioncountdashlet.activeTab.toString().replace(',7','');
						// reset the page param after going previous page
						//var itemStore = applicationcountdashlet.items.get(2).getStore();
						//itemStore.currentPage = 1;
						//applicationcountdashlet.loadDashlet();
					}
				}));
				
				if(admissioncountdashlet.activeTab.toString().indexOf(7)==-1){
					admissioncountdashlet.activeTab = admissioncountdashlet.activeTab.toString() + ',7';
				}
				
				admissioncountdashlet.addForProgramCategory_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroup_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatch_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.addGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.addExportToPdf(admissioncountdashlet,portlet);
				admissioncountdashlet.addExportToExcel(admissioncountdashlet,portlet);
			},
			deactivate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				
				admissioncountdashlet.removeProgramCategory_ADM();
				admissioncountdashlet.removeProgramGroup_ADM();
				admissioncountdashlet.removeProgramBatch_ADM();
				admissioncountdashlet.removeProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.removeGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.removeExportToPdf();
				admissioncountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var admissionCountGrid = cell.up('grid');
					var columnName = admissionCountGrid.columnManager.columns[cellIndex].dataIndex;

					var selectedRecord = admissionCountGrid.getSelectionModel().getSelection()[0];
					var admissioncountdashlet=admissionCountGrid.up('admissioncountdashlet');
					if(columnName == 'academyLocationName') {
						admissioncountdashlet.getLayout().setActiveItem(9);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}
					else if(columnName == 'confirmedCount') {
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'trialCount'){
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'provisionalCount'){
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'totalAdmission'){
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId
						};	
						admissioncountdashlet.loadDashlet(paramsObj);
					}
					admissionCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},{
		fields:['id','personId','progamBatchSeatConfigId','code','printName','admissionId'],
		itemId: 'studentListInnerItem_ADM',
		title:getCommonTranslation('ADMISSION_COUNT'),
		header:false,
		url : SERVERURL.COUNT_ADMISSION_STUDENT_LIST,
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('STUDENT_CODE'),
			dataIndex: 'code',
			sortable : true,
			tpl: '<a>{code}</a>',
			 renderer: function(value) {
				 value="<a href='#'>"+value+"</a>"; 
	             return value;
	         },
			flex:0.5
		}, {
			text : getAdmissionTranslation('STUDENT_NAME'),
			dataIndex : 'printName',
			sortable : true,
			flex:0.5
		},{
			hidden: true,
			dataIndex: 'id'
		},  {
			hidden: true,
			dataIndex: 'personId'
		},  {
			hidden: true,
			dataIndex: 'progamBatchSeatConfigId'
		}],
		listeners:{
			activate:function(portlet){		
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				Ext.each(admissioncountdashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						admissioncountdashlet.getHeader().remove(currentHeaderTool);
					}
				});
				var previousTab2 = admissioncountdashlet.activeTab.toString().split(',')[admissioncountdashlet.activeTab.toString().split(',').length-1];
				admissioncountdashlet.addTool(Ext.create('Ext.panel.Tool',{
					type: 'prev',
					handler: function(btn, target, header, tool){
						header.ownerCt.getLayout().setActiveItem(parseInt(previousTab2));
						header.remove(tool);
						admissioncountdashlet.params={};
						admissioncountdashlet.activeTab = admissioncountdashlet.activeTab.toString().replace(',8','');
						// reset the page param after going previous page
						//var itemStore = applicationcountdashlet.items.get(2).getStore();
						//itemStore.currentPage = 1;
						//applicationcountdashlet.loadDashlet();
					}
				}));
				
				if(admissioncountdashlet.activeTab.toString().indexOf(8)==-1){
					admissioncountdashlet.activeTab = admissioncountdashlet.activeTab.toString() + ',8';
				}
				
				admissioncountdashlet.addForProgramCategory_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroup_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatch_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.addGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.addExportToPdf(admissioncountdashlet,portlet);
				admissioncountdashlet.addExportToExcel(admissioncountdashlet,portlet);
			},
			deactivate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				
				admissioncountdashlet.removeProgramCategory_ADM();
				admissioncountdashlet.removeProgramGroup_ADM();
				admissioncountdashlet.removeProgramBatch_ADM();
				admissioncountdashlet.removeProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.removeGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.removeExportToPdf();
				admissioncountdashlet.removeExportToExcel();
			},
    		cellclick: function( cell, td, cellIndex) {
    			var admissionCountGrid = cell.up('grid');
    			var columnName = admissionCountGrid.columnManager.columns[cellIndex].dataIndex;
    			if(columnName == 'code') {
    				var record = admissionCountGrid.getSelectionModel().getSelection()[0];
    				var userId = record.get('id');
    				if(!isNullOrEmpty(userId)) {
					 	var tabTitle = record.get('code');
			            var personId = record.get('personId');
			            var programBatchSeatTypeConfigId = record.get('progamBatchSeatConfigId');
			            var admissionId=record.get('admissionId');
			            Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
			            var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
			            personController.isProfilePicSaved = false;
			            personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
    				}
    			}
    		}
		}
	},
	{
		xtype:'griddashlet',
		itemId:'programBatchItemWOAL_ADM',
		title:getCommonTranslation('ADMISSION_COUNT'),
		header:false,
		model:'Academia.model.admission.AdmissionTallyDashletModel', //need to change this
		url : SERVERURL.COUNT_ADMISSION_PROGRAM_BATCH, //need to change this
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('PROGRAM'),
			dataIndex : 'programName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('BATCH'),
			dataIndex : 'batchName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('SEAT_TYPE'),
			dataIndex : 'seatType',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('CONFIRMED_ADMISSION'),
			dataIndex : 'confirmedCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TRIAL_ADMISSION'),
			dataIndex : 'trialCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('PROVISIONAL_ADMISSION'),
			dataIndex : 'provisionalCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TOTAL_ADMISSIONS'),
			dataIndex : 'totalAdmission',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			header : getCommonTranslation('PERCENTAGE_SEATS_FILLED'),
			dataIndex : 'percentageSeatsFilled',
			//flex : .2,
			sortable : true,
			renderer:function(value, rec){
				return value+'%';
			}
		}],
		listeners:{
			activate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				Ext.each(admissioncountdashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						admissioncountdashlet.getHeader().remove(currentHeaderTool);
					}
				});
				var previousTab3 = "7";
				admissioncountdashlet.addTool(Ext.create('Ext.panel.Tool',{
					type: 'prev',
					handler: function(btn, target, header, tool){
						header.ownerCt.getLayout().setActiveItem(parseInt(previousTab3));
						header.remove(tool);
						admissioncountdashlet.params={};
						admissioncountdashlet.activeTab = admissioncountdashlet.activeTab.toString().replace(',9','');
						// reset the page param after going previous page
						//var itemStore = applicationcountdashlet.items.get(2).getStore();
						//itemStore.currentPage = 1;
						//applicationcountdashlet.loadDashlet();
					}
				}));
				
				if(admissioncountdashlet.activeTab.toString().indexOf(9)==-1){
					admissioncountdashlet.activeTab = admissioncountdashlet.activeTab.toString() + ',9';
				}
				
				admissioncountdashlet.addForProgramCategory_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroup_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatch_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.addGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.addExportToPdf(admissioncountdashlet,portlet);
				admissioncountdashlet.addExportToExcel(admissioncountdashlet,portlet);
			},
			deactivate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				
				admissioncountdashlet.removeProgramCategory_ADM();
				admissioncountdashlet.removeProgramGroup_ADM();
				admissioncountdashlet.removeProgramBatch_ADM();
				admissioncountdashlet.removeProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.removeGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.removeExportToPdf();
				admissioncountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var admissionCountGrid = cell.up('grid');
					var columnName = admissionCountGrid.columnManager.columns[cellIndex].dataIndex;

					var selectedRecord = admissionCountGrid.getSelectionModel().getSelection()[0];
					var admissioncountdashlet=admissionCountGrid.up('admissioncountdashlet');
					if(columnName == 'confirmedCount') {
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id,
								program1Id:selectedRecord.data.program1Id,
								batch1Id:selectedRecord.data.batch1Id
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id,
								program1Id:selectedRecord.data.program1Id,
								batch1Id:selectedRecord.data.batch1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'trialCount'){
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								program1Id:selectedRecord.data.program1Id,
								batch1Id:selectedRecord.data.batch1Id
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								program1Id:selectedRecord.data.program1Id,
								batch1Id:selectedRecord.data.batch1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'provisionalCount'){
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								program1Id:selectedRecord.data.program1Id,
								batch1Id:selectedRecord.data.batch1Id
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								program1Id:selectedRecord.data.program1Id,
								batch1Id:selectedRecord.data.batch1Id
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'totalAdmission'){
						admissioncountdashlet.getLayout().setActiveItem(8);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id,
								program1Id:selectedRecord.data.program1Id,
								batch1Id:selectedRecord.data.batch1Id
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id,
								program1Id:selectedRecord.data.program1Id,
								batch1Id:selectedRecord.data.batch1Id
						};	
						admissioncountdashlet.loadDashlet(paramsObj);
					}
					admissionCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},
	
	
	{
		xtype:'griddashlet',
		itemId:'academicLocationInnerItem_GEN_ADM',
		title:getCommonTranslation('ADMISSION_COUNT'),
		header:false,
		model:'Academia.model.admission.AdmissionTallyDashletModel', //need to change this
		url : SERVERURL.COUNT_ADMISSION_ACADEMY_LOCATION_GENDER_WISE, //need to change this
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('ACADEMY_LOCATION'),
			dataIndex : 'academyLocationName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('GENDER'),
			dataIndex : 'genderCSM',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value=getCommonTranslation(value);
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('SEAT_TYPE'),
			dataIndex : 'seatType',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('CONFIRMED_ADMISSION'),
			dataIndex : 'confirmedCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TRIAL_ADMISSION'),
			dataIndex : 'trialCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('PROVISIONAL_ADMISSION'),
			dataIndex : 'provisionalCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TOTAL_ADMISSIONS'),
			dataIndex : 'totalAdmission',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			header : getCommonTranslation('PERCENTAGE_SEATS_FILLED'),
			dataIndex : 'percentageSeatsFilled',
			//flex : .2,
			sortable : true,
			renderer:function(value, rec){
				return value+'%';
			}
		}],
		listeners:{
			activate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');

				var previousBtnTab = admissioncountdashlet.activeTab.toString().split(',')[0];
				admissioncountdashlet.addTool(Ext.create('Ext.panel.Tool',{
					type: 'prev',
					handler: function(btn, target, header, tool){
						header.ownerCt.getLayout().setActiveItem(parseInt(previousBtnTab));
						header.remove(tool);
						admissioncountdashlet.params={};
						admissioncountdashlet.activeTab = admissioncountdashlet.activeTab.toString().replace(',7','');
						// reset the page param after going previous page
						//var itemStore = applicationcountdashlet.items.get(2).getStore();
						//itemStore.currentPage = 1;
						//applicationcountdashlet.loadDashlet();
					}
				}));
				
				if(admissioncountdashlet.activeTab.toString().indexOf(10)==-1){
					admissioncountdashlet.activeTab = admissioncountdashlet.activeTab.toString() + ',10';
				}
				
				admissioncountdashlet.addForProgramCategory_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroup_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatch_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.addGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.addExportToPdf(admissioncountdashlet,portlet);
				admissioncountdashlet.addExportToExcel(admissioncountdashlet,portlet);
			},
			deactivate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				
				admissioncountdashlet.removeProgramCategory_ADM();
				admissioncountdashlet.removeProgramGroup_ADM();
				admissioncountdashlet.removeProgramBatch_ADM();
				admissioncountdashlet.removeProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.removeGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.removeExportToPdf();
				admissioncountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var admissionCountGrid = cell.up('grid');
					var columnName = admissionCountGrid.columnManager.columns[cellIndex].dataIndex;

					var selectedRecord = admissionCountGrid.getSelectionModel().getSelection()[0];
					var admissioncountdashlet=admissionCountGrid.up('admissioncountdashlet');
					if(columnName == 'academyLocationName') {
						admissioncountdashlet.getLayout().setActiveItem(12);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}
					else if(columnName == 'confirmedCount') {
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'trialCount'){
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'provisionalCount'){
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'totalAdmission'){
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id,
								programGroupId: selectedRecord.data.programGroupId,
								programCategoryId: selectedRecord.data.programCategoryId,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};	
						admissioncountdashlet.loadDashlet(paramsObj);
					}
					admissionCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},{
		fields:['id','personId','progamBatchSeatConfigId','code','printName','admissionId'],
		itemId: 'studentListInnerItem_GEN_ADM',
		title:getCommonTranslation('ADMISSION_COUNT'),
		header:false,
		url : SERVERURL.COUNT_ADMISSION_STUDENT_LIST,
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('STUDENT_CODE'),
			dataIndex: 'code',
			sortable : true,
			tpl: '<a>{code}</a>',
			 renderer: function(value) {
				 value="<a href='#'>"+value+"</a>"; 
	             return value;
	         },
			flex:0.5
		}, {
			text : getAdmissionTranslation('STUDENT_NAME'),
			dataIndex : 'printName',
			sortable : true,
			flex:0.5
		},{
			hidden: true,
			dataIndex: 'id'
		},  {
			hidden: true,
			dataIndex: 'personId'
		},  {
			hidden: true,
			dataIndex: 'progamBatchSeatConfigId'
		}],
		listeners:{
			activate:function(portlet){		
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				Ext.each(admissioncountdashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						admissioncountdashlet.getHeader().remove(currentHeaderTool);
					}
				});
				var previousTab2 = admissioncountdashlet.activeTab.toString().split(',')[admissioncountdashlet.activeTab.toString().split(',').length-1];
				admissioncountdashlet.addTool(Ext.create('Ext.panel.Tool',{
					type: 'prev',
					handler: function(btn, target, header, tool){
						header.ownerCt.getLayout().setActiveItem(parseInt(previousTab2));
						header.remove(tool);
						admissioncountdashlet.params={};
						admissioncountdashlet.activeTab = admissioncountdashlet.activeTab.toString().replace(',11','');
						// reset the page param after going previous page
						//var itemStore = applicationcountdashlet.items.get(2).getStore();
						//itemStore.currentPage = 1;
						//applicationcountdashlet.loadDashlet();
					}
				}));
				
				if(admissioncountdashlet.activeTab.toString().indexOf(11)==-1){
					admissioncountdashlet.activeTab = admissioncountdashlet.activeTab.toString() + ',11';
				}
				
				admissioncountdashlet.addForProgramCategory_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroup_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatch_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.addGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.addExportToPdf(admissioncountdashlet,portlet);
				admissioncountdashlet.addExportToExcel(admissioncountdashlet,portlet);
			},
			deactivate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				
				admissioncountdashlet.removeProgramCategory_ADM();
				admissioncountdashlet.removeProgramGroup_ADM();
				admissioncountdashlet.removeProgramBatch_ADM();
				admissioncountdashlet.removeProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.removeGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.removeExportToPdf();
				admissioncountdashlet.removeExportToExcel();
			},
    		cellclick: function( cell, td, cellIndex) {
    			var admissionCountGrid = cell.up('grid');
    			var columnName = admissionCountGrid.columnManager.columns[cellIndex].dataIndex;
    			if(columnName == 'code') {
    				var record = admissionCountGrid.getSelectionModel().getSelection()[0];
    				var userId = record.get('id');
    				if(!isNullOrEmpty(userId)) {
    					var tabTitle = record.get('code');
			            var personId = record.get('personId');
			            var programBatchSeatTypeConfigId = record.get('progamBatchSeatConfigId');
			            var admissionId=record.get('admissionId');
			            Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
			            var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
			            personController.isProfilePicSaved = false;
			            personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, admissionId, programBatchSeatTypeConfigId);
    				}
    			}
    		}
		}
	},
	{
		xtype:'griddashlet',
		itemId:'programBatchItemWOAL_GEN_ADM',
		title:getCommonTranslation('ADMISSION_COUNT'),
		header:false,
		model:'Academia.model.admission.AdmissionTallyDashletModel', //need to change this
		url : SERVERURL.COUNT_ADMISSION_PROGRAM_BATCH_GENDER_WISE, //need to change this
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('PROGRAM'),
			dataIndex : 'programName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('GENDER'),
			dataIndex : 'genderCSM',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value=getCommonTranslation(value);
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('BATCH'),
			dataIndex : 'batchName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('SEAT_TYPE'),
			dataIndex : 'seatType',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value;
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('CONFIRMED_ADMISSION'),
			dataIndex : 'confirmedCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TRIAL_ADMISSION'),
			dataIndex : 'trialCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('PROVISIONAL_ADMISSION'),
			dataIndex : 'provisionalCount',
			sortable : true,
			hidden: true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getCommonTranslation('TOTAL_ADMISSIONS'),
			dataIndex : 'totalAdmission',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			header : getCommonTranslation('PERCENTAGE_SEATS_FILLED'),
			dataIndex : 'percentageSeatsFilled',
			//flex : .2,
			sortable : true,
			renderer:function(value, rec){
				return value+'%';
			}
		}],
		listeners:{
			activate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				Ext.each(admissioncountdashlet.getHeader().getTools(),function(currentHeaderTool){
					if(Ext.isDefined(currentHeaderTool.type) && currentHeaderTool.type=="prev"){
						admissioncountdashlet.getHeader().remove(currentHeaderTool);
					}
				});
				var previousTab3 = "10";
				admissioncountdashlet.addTool(Ext.create('Ext.panel.Tool',{
					type: 'prev',
					handler: function(btn, target, header, tool){
						header.ownerCt.getLayout().setActiveItem(parseInt(previousTab3));
						header.remove(tool);
						admissioncountdashlet.params={};
						admissioncountdashlet.activeTab = admissioncountdashlet.activeTab.toString().replace(',12','');
						// reset the page param after going previous page
						//var itemStore = applicationcountdashlet.items.get(2).getStore();
						//itemStore.currentPage = 1;
						//applicationcountdashlet.loadDashlet();
					}
				}));
				
				if(admissioncountdashlet.activeTab.toString().indexOf(12)==-1){
					admissioncountdashlet.activeTab = admissioncountdashlet.activeTab.toString() + ',12';
				}
				
				admissioncountdashlet.addForProgramCategory_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroup_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatch_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.addForProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.addGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.addExportToPdf(admissioncountdashlet,portlet);
				admissioncountdashlet.addExportToExcel(admissioncountdashlet,portlet);
			},
			deactivate:function(portlet){
				var admissioncountdashlet=portlet.up('admissioncountdashlet');
				
				admissioncountdashlet.removeProgramCategory_ADM();
				admissioncountdashlet.removeProgramGroup_ADM();
				admissioncountdashlet.removeProgramBatch_ADM();
				admissioncountdashlet.removeProgramCategoryGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramGroupGenderWise_ADM(admissioncountdashlet,portlet);
				admissioncountdashlet.removeProgramBatchGenderWise_ADM(admissioncountdashlet,portlet);

				//admissioncountdashlet.removeGraphViewButton(admissioncountdashlet);
				admissioncountdashlet.removeExportToPdf();
				admissioncountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var admissionCountGrid = cell.up('grid');
					var columnName = admissionCountGrid.columnManager.columns[cellIndex].dataIndex;

					var selectedRecord = admissionCountGrid.getSelectionModel().getSelection()[0];
					var admissioncountdashlet=admissionCountGrid.up('admissioncountdashlet');
					if(columnName == 'confirmedCount') {
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id,
								program1Id:selectedRecord.data.program1Id,
								batch1Id:selectedRecord.data.batch1Id,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'CONFIRMED',
								seatType1Id:selectedRecord.data.seatType1Id,
								program1Id:selectedRecord.data.program1Id,
								batch1Id:selectedRecord.data.batch1Id,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'trialCount'){
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								program1Id:selectedRecord.data.program1Id,
								batch1Id:selectedRecord.data.batch1Id,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'TRIAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								program1Id:selectedRecord.data.program1Id,
								batch1Id:selectedRecord.data.batch1Id,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'provisionalCount'){
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								program1Id:selectedRecord.data.program1Id,
								batch1Id:selectedRecord.data.batch1Id,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'PROVISIONAL',
								seatType1Id:selectedRecord.data.seatType1Id,
								program1Id:selectedRecord.data.program1Id,
								batch1Id:selectedRecord.data.batch1Id,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};
						admissioncountdashlet.loadDashlet(paramsObj);
					}else if(columnName == 'totalAdmission'){
						admissioncountdashlet.getLayout().setActiveItem(11);
						admissioncountdashlet.params={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id,
								program1Id:selectedRecord.data.program1Id,
								batch1Id:selectedRecord.data.batch1Id,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};
						var paramsObj={
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'ALL',
								seatType1Id:selectedRecord.data.seatType1Id,
								program1Id:selectedRecord.data.program1Id,
								batch1Id:selectedRecord.data.batch1Id,
								genderCSM: selectedRecord.data.genderCSM,
								genderId: selectedRecord.data.genderId
						};	
						admissioncountdashlet.loadDashlet(paramsObj);
					}
					admissionCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	}
	
	
	]
});
