/**
 * @author Akshay Sharma
 */
var periodId = null;
var sectionId = null;
var programName = null;
var studentAttendancetypeCD = null;
var attendanceTypeCD = [];
var programWise = false;
var sessionWise = false;
var permissionList=null;
Ext.define('Academia.view.dashboard.dashlets.CompleteDayCourseDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.completedaycoursedashlet',
	graphView:true,
	layout:'card',
	activeItem: 0, 
	cls:'CompleteDayCourseDashletCLS dashlet',
	loadDashlet :function(){
		var this$=this;
		var view= this.layout.getActiveItem();
		
		if(view.xtype=='stackbarchartverticaldashlet' || view.xtype=='griddashlet'){
			if(view.xtype!='griddashlet'){
				programWise = false;
				sessionWise = false;
			}
			var store= view.getStore();
			store.removeAll();
			userId = this$.getCurrentlyLoggedInDashletUser().id;
			academyLocationId = this$.getUserCurrentAcademyLocation();
			var permissionsMap = new Ext.util.HashMap();
			permissionsMap = Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('FACULTY_PORTAL_ATTENDANCE_DASHLET_PRIVILEGES');
			var associatedAcadLocationIds = new Array();
		    associatedAcadLocationIds.push(academyLocationId);
			permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
			
			Ext.Ajax.request({
				type : 'rest',
				async: false,
				url : SERVERURL.GET_SESSION_VALUE_BY_ACA_LOCATION,
				params : {
					academyLocatonId : academyLocationId
				},
				method : 'GET',
				success : function(f, action) {
					if(isNullOrEmpty(f.responseText))
					{
						showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));	 
					} else {
						var res = Ext.JSON.decode(f.responseText);
						var view= this$.layout.getActiveItem();
						attendanceTypeCD = [];
						Ext.each(res, function(data) {
							attendanceTypeCD.push(data.studentAttendanceType);
						});
						
						//--checking for the visible tabs
						if((Ext.Array.contains(permissionList, 'PROGRAM_WISE')) && ((Ext.Array.contains(attendanceTypeCD, 'COMPLETE_DAY') || Ext.Array.contains(attendanceTypeCD, 'Complete Day')) && (view.itemId=="completeMainCDItemId" || programWise))){
							programWise = true;
							studentAttendancetypeCD = 'COMPLETE_DAY';
						}
						else if((Ext.Array.contains(permissionList, 'SESSION_WISE')) && ((Ext.Array.contains(attendanceTypeCD, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceTypeCD, 'Multiple Session')) && (view.itemId=="multiMainCDItemId" || sessionWise))){
							sessionWise=true;
							studentAttendancetypeCD = 'MULTIPLE_SESSION';
						}
						else if((Ext.Array.contains(permissionList, 'PROGRAM_WISE')) && ((Ext.Array.contains(attendanceTypeCD, 'COMPLETE_DAY') || Ext.Array.contains(attendanceTypeCD, 'Complete Day')))){
							programWise = true;
							studentAttendancetypeCD = 'COMPLETE_DAY';
							defaultView = 'COMPLETE_DAY';
						}
						else if((Ext.Array.contains(permissionList, 'SESSION_WISE')) && ((Ext.Array.contains(attendanceTypeCD, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceTypeCD, 'Multiple Session')))){
							sessionWise=true;
							studentAttendancetypeCD = 'MULTIPLE_SESSION';
							defaultView = 'MULTIPLE_SESSION';
						}
						if(!programWise && !sessionWise){
							programWise = true;
							studentAttendancetypeCD = 'COMPLETE_DAY';
							defaultView = 'COMPLETE_DAY';
						}
						if(programWise){
							var view= this$.layout.getActiveItem();
							if(view.xtype=='griddashlet'){
								setTimeout(function(){
								var programField = view.up().down('customcombobox');
								var sectionId = programField.getValue();
								var extraparams=this$.getParams();
								store.getProxy().extraParams = {
									userId: userId,
									periodId:periodId,
									sectionId:sectionId,
									attendancetype: 'COMPLETE_DAY'
								};
								store.load({params:extraparams,
									callback: function(rec, operation, success) {
										if(rec != null){
											if(rec.length==0){
												//this$.layout.setActiveItem(0);
											}
										}
									}
								});
								},500);
							}else{
								var programIds = new Array(); 
								setTimeout(function(){
								var programField = this$.down('customcombobox');
								var sectionId = programField.getValue();
								store.getProxy().extraParams = {
									userId: userId,
									sectionId : sectionId,
									attendancetype: 'COMPLETE_DAY'
								};
								store.load({
									sync:false,
									callback: function(rec, operation, success) {
										if(rec != null){
											for(var i = 0; i<rec.length;i++){
												if(!isNullOrEmpty(rec[i].get('programId'))){
													programId = rec[i].get('programId');
													programName = rec[i].get('programName');
													sectionName = rec[i].get('sectionCode');
													periodId = rec[i].get('periodId');
													sectionId= rec[i].get('sectionId');
													var ba = view.axes.get('bottom');
													ba.setTitle(programName+" - "+sectionName);
												}
											}
										}
									}
								});
								},500);
							}
						}
						else if(sessionWise){
							var view= this$.layout.getActiveItem();
							if(view.xtype=='griddashlet'){
								setTimeout(function(){
								var programField = view.up().down('customcombobox');
								var sectionId = programField.getValue();
								var extraparams=this$.getParams();
								store.getProxy().extraParams = {
									userId: userId,
									periodId:periodId,
									sectionId:sectionId,
									attendancetype: 'MULTIPLE_SESSION'
								};
								store.load({params:extraparams,
									callback: function(rec, operation, success) {
										if(rec != null){
											if(rec.length==0){
												//this$.layout.setActiveItem(2);
											}
										}
									}
								});
								},500);
							}else{
								var programIds = new Array(); 
								setTimeout(function(){
								var programField = this$.down('customcombobox');
								var sectionId = programField.getValue();
								this$.layout.setActiveItem(2);
								store.getProxy().extraParams = {
									userId: userId,
									sectionId : sectionId,
									attendancetype: 'MULTIPLE_SESSION'
								};
								store.load({
									sync:false,
									callback: function(rec, operation, success) {
										if(rec != null){
											for(var i = 0; i<rec.length;i++){
												if(!isNullOrEmpty(rec[i].get('programId'))){
													programId = rec[i].get('programId');
													programName = rec[i].get('programName');
													sectionName = rec[i].get('sectionCode');
													periodId = rec[i].get('periodId');
													sectionId= rec[i].get('sectionId');
													var ba = view.axes.get('bottom');
													ba.setTitle(programName+" - "+sectionName);
												}
											}
										}
									}
								});
								},500);
							}
						}
					}
				}
			});
		}
	},
	defaults: {
		cls:'panelNoSpace',
		xtype:'griddashlet'
	},
	items:[{
		xtype:'stackbarchartverticaldashlet',
		itemId:'completeMainCDItemId',
		yAxesNumericField :['Present','Leave','Absent'],
		xAxesCategoryField : ['dateValue'],
		titleLegend:[getProgramandcourseTranslation('PRESENT'), getProgramandcourseTranslation('Leave'), getProgramandcourseTranslation('Absent')],
		yAxesNumericTitle :getCommonTranslation('ATTENDANCCE_PER'),
		xAxesCategoryTitle :getProgramandcourseTranslation('DATES'),
		headingTitle : programName,
		model:'Academia.model.attendance.PendingAttendanceGridModel',
		url : SERVERURL.GET_COMPLETE_DAY_COURSE_DASHLET,
		listeners:{
			activate:function(portlet){
				var completedaycoursedashlet=portlet.up('completedaycoursedashlet');
				completedaycoursedashlet.activeTab = 0;
				completedaycoursedashlet.down('customcombobox').up().setVisible(true);
				completedaycoursedashlet.addMarkAttendanceLink(completedaycoursedashlet,portlet);
				completedaycoursedashlet.addStudentList(completedaycoursedashlet,portlet);
				completedaycoursedashlet.addSendMessageLink(completedaycoursedashlet,portlet);
				completedaycoursedashlet.addExportToPng(completedaycoursedashlet,portlet);
				if((Ext.Array.contains(permissionList, 'SESSION_WISE')) && ((Ext.Array.contains(attendanceTypeCD, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceTypeCD, 'Multiple Session')))){
					completedaycoursedashlet.addSessionWiseCDList(completedaycoursedashlet,portlet);
				}
			},
			deactivate:function(portlet){
				var completedaycoursedashlet=portlet.up('completedaycoursedashlet');
				completedaycoursedashlet.removeMarkAttendanceLink();
				completedaycoursedashlet.removeStudentList();
				completedaycoursedashlet.removeSendMessageLink();
				completedaycoursedashlet.removeExportToPng();
				if((Ext.Array.contains(permissionList, 'SESSION_WISE')) && ((Ext.Array.contains(attendanceTypeCD, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceTypeCD, 'Multiple Session')))){
					completedaycoursedashlet.removeSessionWiseCDList();
				}
			}
		}
	},{
		fields:['admissionCode','studentCode','studentName','attendancePercentage','emailId','contactNo','id','personId','progamBatchSeatConfigId','birthDate','fatherName','motherName'],
		url : SERVERURL.GET_STUDENT_COMPLETE_DAY_ATTENDANCE_DASHLET,
		itemId : 'studentListItemId',
		addPagingToolbar : true,
		tbar : [  {
			xtype: 'button',
			text: getCommonTranslation('RESET_PASSWORD'),
			itemId: 'resetPasswordDashletItemId',
			buttonAlign: 'left',
			cls: 'dashbordOtherTbarBtn',
			scale: CONSTANTS.BUTTONSIZE
		}],
		columns : [{
			text : getCommonTranslation('ADMISSION_ID'),
			dataIndex: 'admissionCode',
			sortable : true,
			flex:1
		}, {
			text : getCommonTranslation('STUDENT_ID'),
			dataIndex : 'studentCode',
			sortable : true,
			flex:1
		},{
			text : getCommonTranslation('STUDENT_NAME'),
			dataIndex : 'studentName',
			sortable : true,
			flex:1
		},{
			text : getAdmissionTranslation('EMAIL_ID'),
			dataIndex : 'emailId',
			sortable : true,
			flex:1
		},{
			text : getAdmissionTranslation('CONTACT_NO'),
			dataIndex : 'contactNo',
			sortable : true,
			flex:1
		},{
			text : getCommonTranslation('ATTENDANCE_PERCENTAGE'),
			dataIndex : 'attendancePercentage',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					value=value+"%"; 
				}else{
					value= ''; 
				}
				return value;
			},
			flex:1
		},{
			text : getAdmissionTranslation('DOB'),
			dataIndex : 'birthDate',
			sortable : true,
			flex:1,
			hidden:true,
			renderer:function(value){
	        	if(!isNullOrEmpty(value)){
	        		return dateRender(value);
	        	}
	        	else{
	        		return '';
	        	}
	        }
		}, {
			text : getAdmissionTranslation('FATHER_NAME'),
			dataIndex : 'fatherName',
			sortable : true,
			flex:1,
			hidden:true
		}, {
			text : getCommonTranslation('MOTHERS_NAME'),
			dataIndex : 'motherName',
			sortable : true,
			flex:1,
			hidden:true
		}],
		listeners:{
			activate:function(portlet){
				var completedaycoursedashlet=portlet.up('completedaycoursedashlet');
				completedaycoursedashlet.down('customcombobox').up().setVisible(false);
				completedaycoursedashlet.activeTab = 1;
				completedaycoursedashlet.addMarkAttendanceLink(completedaycoursedashlet,portlet);
				completedaycoursedashlet.addSendMessageLink(completedaycoursedashlet,portlet);
				completedaycoursedashlet.addExportToExcel(completedaycoursedashlet,portlet);
				completedaycoursedashlet.addExportToPdf(completedaycoursedashlet,portlet);
				completedaycoursedashlet.addTool(Ext.create('Ext.panel.Tool',{
					type: 'prev',
					handler: function(btn, target, header, tool){
						if(sessionWise){
							header.ownerCt.getLayout().setActiveItem(2);
						}else{
							header.ownerCt.getLayout().setActiveItem(0);
						}
						header.remove(tool);
						completedaycoursedashlet.params={};
						// reset the page param after going previous page
						var itemStore = completedaycoursedashlet.items.get(0).getStore();
						itemStore.currentPage = 1;
						completedaycoursedashlet.loadDashlet();
					}
				}));
			},
			deactivate:function(portlet){
				var completedaycoursedashlet=portlet.up('completedaycoursedashlet');
				completedaycoursedashlet.removeExportToPdf();
				completedaycoursedashlet.removeExportToExcel();
				completedaycoursedashlet.removeMarkAttendanceLink();
				completedaycoursedashlet.removeSendMessageLink();
			},
		}
	},{
		xtype:'stackbarchartverticaldashlet',
		itemId:'multiMainCDItemId',
		yAxesNumericField :['Present','Leave','Absent'],
		xAxesCategoryField : ['dateValue'],
		titleLegend:[getProgramandcourseTranslation('PRESENT'), getProgramandcourseTranslation('Leave'), getProgramandcourseTranslation('Absent')],
		yAxesNumericTitle :getCommonTranslation('ATTENDANCCE_PER'),
		xAxesCategoryTitle :getProgramandcourseTranslation('DATES'),
		headingTitle : programName,
		model:'Academia.model.attendance.PendingAttendanceGridModel',
		url : SERVERURL.GET_COMPLETE_DAY_COURSE_DASHLET,
		listeners:{
			activate:function(portlet){
				var completedaycoursedashlet=portlet.up('completedaycoursedashlet');
				completedaycoursedashlet.activeTab = 2;
				completedaycoursedashlet.down('customcombobox').up().setVisible(true);
				completedaycoursedashlet.addMarkAttendanceLink(completedaycoursedashlet,portlet);
				completedaycoursedashlet.addStudentList(completedaycoursedashlet,portlet);
				completedaycoursedashlet.addSendMessageLink(completedaycoursedashlet,portlet);
				completedaycoursedashlet.addExportToPng(completedaycoursedashlet,portlet);
				if((Ext.Array.contains(permissionList, 'PROGRAM_WISE')) && ((Ext.Array.contains(attendanceTypeCD, 'COMPLETE_DAY') || Ext.Array.contains(attendanceTypeCD, 'Complete Day')))){
					completedaycoursedashlet.addProgramWiseCDList(completedaycoursedashlet,portlet);
				}
			},
			deactivate:function(portlet){
				var completedaycoursedashlet=portlet.up('completedaycoursedashlet');
				completedaycoursedashlet.removeMarkAttendanceLink();
				completedaycoursedashlet.removeStudentList();
				completedaycoursedashlet.removeSendMessageLink();
				completedaycoursedashlet.removeExportToPng();
				if((Ext.Array.contains(permissionList, 'PROGRAM_WISE')) && ((Ext.Array.contains(attendanceTypeCD, 'COMPLETE_DAY') || Ext.Array.contains(attendanceTypeCD, 'Complete Day')))){
					completedaycoursedashlet.removeProgramWiseCDList();
				}
			}
		}
	}],
	tbar: {
		cls: 'studentlookupdashbordTbar',
		style:{marginLeft:'-10px',
			'background': '#E7F9FF !important',
			'background-color': '#E7F9FF !important'
		},
		items: [{
			xtype: 'customcombobox',
			name: 'programId',
			itemId: 'programComboFieldItemId',
			fieldLabel: getProgramandcourseTranslation('PROGRAM'),
			store:'common.ClassTeacherProgramDashletStore',
			width : 420,
			allowBlank: true,
			valueField: 'id',
			labelWidth : 65,
			displayField: 'codeValue',
			triggerAction: 'all',
			queryParam:'name',
			cls:'completeDayCourseProgram',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}/*,
			listeners: {
				beforeshow: function() {
					console.log('---before show----');
					console.trace();
					console.log('-------');
				},
				beforehide: function() {
					console.log('---before hide----');
					console.trace();
					console.log('-------');
				}
			},*/
		}]
	}
});