Ext.define('Academia.view.dashboard.dashlets.CompletionCountDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.completioncountdashlet',

   /* requires : ['Academia.view.dashboard.dashlets.GridDashlet' ], */

    graphView:true,
    layout:'card',
    activeItem: 0, 
    autoScroll:false,
    cls:'CompletionCountDashletCLS dashlet',
	loadDashlet :function(){
	    var this$=this;
	    var view= this.layout.getActiveItem();
	    if(view.xtype=='griddashlet' || view.xtype=='columnchartdashlet'){
	    	var store= view.getStore();
	    	var extraparams=this$.getParams();
	    	store.load({params:extraparams,
	    		callback: function(rec, operation, success) {
	    			if(rec.length==0){
	    				this$.layout.setActiveItem(3);
	    			}
	    		}
	    	});
	    }
	},
	defaults: {
		cls:'panelNoSpace',
		xtype:'griddashlet'
    },
    
	items:[{
		fields : ['programBatchSeatConfigurationId','academyName', 'locationName','academyLocationName', 'programName',
		          'batchName', 'seatName', 'count','completionCategory'],
		title:getCommonTranslation('COMPLETION_COUNT'),
		header:false,          
		url : SERVERURL.FIND_COMPLETION_COUNT,
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('ACADEMY_LOCATION'),
			dataIndex: 'academyLocationName',
			sortable : true,
			flex:0.3
		}, {
			text : getAdmissionTranslation('PROGRAM'),
			dataIndex : 'programName',
			sortable : true,
			flex:0.3
		}, {
			text : getAdmissionTranslation('BATCH'),
			dataIndex : 'batchName',
			sortable : true,
			flex:0.2
		},  {
			text : getAdmissionTranslation('SEAT_TYPE'),
			dataIndex: 'seatName',
			sortable : true,
			flex:0.2
		},  {
			text : getAdmissionTranslation('Category'),
			dataIndex: 'completionCategory',
			sortable : true,
			flex:0.4,
	        renderer: function(value) {
	            return getAdmissionTranslation(value);
	        }
		},  {
			text : getExaminationTranslation('STUDENT_COUNT'),
			dataIndex: 'count',
			sortable : true,
			tpl: '<a>{count}</a>',
			 renderer: function(value) {
				 value="<a href='#'>"+value+"</a>"; 
	             return value;
	         },
			flex:0.2
		}/*,{
			hidden: true,
			dataIndex: 'id'
		}*/],
		listeners:{
			activate:function(portlet){
				var completioncountdashlet=portlet.up('completioncountdashlet');
				completioncountdashlet.activeTab = 1;
				completioncountdashlet.addGraphViewButton(completioncountdashlet);
				completioncountdashlet.addExportToPdf(completioncountdashlet,portlet);
				completioncountdashlet.addExportToExcel(completioncountdashlet,portlet);
				portlet.doLayout();
			},
			deactivate:function(portlet){
					var completioncountdashlet=portlet.up('completioncountdashlet');
					completioncountdashlet.removeGraphViewButton(completioncountdashlet);
					completioncountdashlet.removeExportToPdf();
					completioncountdashlet.removeExportToExcel();
			},
    		cellclick: function( cell, td, cellIndex) {
    			var completionCountGrid = cell.up('grid');
    			var columnName = completionCountGrid.columnManager.columns[cellIndex].dataIndex;
    			if(columnName == 'count') {
    				var selectedRecord = completionCountGrid.getSelectionModel().getSelection()[0];
    				var id = selectedRecord.get('programBatchSeatConfigurationId');
    				if(!isNullOrEmpty(id)) {
    					var completioncountdashlet=completionCountGrid.up('completioncountdashlet');
    					var completionType=selectedRecord.get('completionCategory');
    					completioncountdashlet.params ={ programBatchSeatConfigurationId : id,type:completionType};
    					completioncountdashlet.getLayout().setActiveItem(2);
    					
    					var store = completioncountdashlet.getLayout().getActiveItem().getStore();
    					store.getProxy().extraParams = {
    						programBatchSeatConfigurationId : id,
    						type : completionType
    					};
    					completioncountdashlet.loadDashlet();
    				}
    			}
    		}
		}
	},{
		xtype:'columnchartdashlet',
		fields : ['programBatchSeatConfigurationId','academyName', 'locationName','academyLocationName', 'programName',
		          'batchName', 'seatName', 'count','completionCategory'],
      	xAxesCategoryField :['academyLocationName','programName', 'batchName','seatName','completionCategory'],
		yAxesNumericField : 'count',
		xAxesCategoryTitle :getCommonTranslation('COMPLETION'),
		yAxesNumericTitle :getCommonTranslation('COUNTS'),
		url : SERVERURL.FIND_COMPLETION_COUNT,
		listeners:{
			activate:function(portlet){
				var completioncountdashlet=portlet.up('completioncountdashlet');
				completioncountdashlet.activeTab = 0;
				completioncountdashlet.addGridViewButton(completioncountdashlet);
				completioncountdashlet.addExportToPng(completioncountdashlet,portlet);
			},
			deactivate:function(portlet){
				var completioncountdashlet=portlet.up('completioncountdashlet');
				completioncountdashlet.removeGridViewButton(completioncountdashlet);
				completioncountdashlet.removeExportToPng();
			}
		}
	},{
		fields:['id','personId','progamBatchSeatConfigId','code','printName','userId'],
		title:getCommonTranslation('COMPLETION_COUNT'),
		header:false, 
		url : SERVERURL.FIND_COMPLETOIN_STUDENT_DETAIL,
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('STUDENT_CODE'),
			dataIndex: 'code',
			sortable : true,
			tpl: '<a>{code}</a>',
			 renderer: function(value) {
				 value="<a href='#'>"+value+"</a>"; 
	             return value;
	         },
			flex:0.5
		}, {
			text : getAdmissionTranslation('STUDENT_NAME'),
			dataIndex : 'printName',
			sortable : true,
			flex:0.5
		},{
			hidden: true,
			dataIndex: 'id'
		},{
			hidden: true,
			dataIndex: 'personId'
		},  {
			hidden: true,
			dataIndex: 'progamBatchSeatConfigId'
		}],
		listeners:{
			activate:function(portlet){
				var completioncountdashlet=portlet.up('completioncountdashlet');
			
				completioncountdashlet.addExportToPdf(completioncountdashlet,portlet);
				completioncountdashlet.addExportToExcel(completioncountdashlet,portlet);
			
				completioncountdashlet.addTool(Ext.create('Ext.panel.Tool',{
		         type: 'prev',
		         handler: function(btn, target, header, tool){
		        	 header.ownerCt.getLayout().setActiveItem(0);
		        	 header.remove(tool);
		        	 completioncountdashlet.params={};
		        	 // reset the page param after going previous page
		        	 var itemStore = completioncountdashlet.items.get(2).getStore();
		        	 itemStore.currentPage = 1;
		        	 completioncountdashlet.loadDashlet();
		        	 }
			     }));

			},
			deactivate:function(portlet){
					var completioncountdashlet=portlet.up('completioncountdashlet');
					completioncountdashlet.removeExportToPdf();
					completioncountdashlet.removeExportToExcel();
			},
    		cellclick: function( cell, td, cellIndex) {
    			var completionCountGrid = cell.up('grid');
    			var columnName = completionCountGrid.columnManager.columns[cellIndex].dataIndex;
    			if(columnName == 'code') {
    				var record = completionCountGrid.getSelectionModel().getSelection()[0];
    				//var userId = record.get('id');
    				var userId = record.get('userId');
    				if(!isNullOrEmpty(userId)) {
					 	var tabTitle = record.get('code');
			            var personId = record.get('personId');
			            var programBatchSeatTypeConfigId = record.get('progamBatchSeatConfigId');
			            Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
			            var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
			            personController.addContentPanelTab(tabTitle, 'studentprofile', userId, personId, null, null, programBatchSeatTypeConfigId);
			            //personController.addContentPanelTab(tabTitle, 'studentprofile', userId, null, null, null, null);
    				}
    			}
    		}
		}
	},{
		xtype: 'panel',
		width: '100%',
		height: '100%',
		html: '<div><div class ="dashletNoRecordFoundImageCls" /><span>'+getCommonTranslation('EMPTY_MESSAGE')+'</span></div>',
		//src: CONSTANTS.NO_DATA_DISPALY_DASHBORD_IMAGE_SRC,//'resources/images/no_data_to_display.png',
		listeners:{
			activate:function(portlet){
				var completioncountdashlet=portlet.up('completioncountdashlet');
				completioncountdashlet.activeTab = 1;
				completioncountdashlet.addGraphViewButton(completioncountdashlet);
				completioncountdashlet.addExportToPdf(completioncountdashlet,portlet);
				completioncountdashlet.addExportToExcel(completioncountdashlet,portlet);
			},
			deactivate:function(portlet){
				var completioncountdashlet=portlet.up('completioncountdashlet');
				completioncountdashlet.removeGraphViewButton(completioncountdashlet);
				completioncountdashlet.removeExportToPdf();
				completioncountdashlet.removeExportToExcel();
			}
		}
	}]
});
