var studentAttendanceType;
var academyLocationId;
var userId;
Ext.define('Academia.view.dashboard.dashlets.CourseDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.coursedashlet',
	graphView:false,
	layout:'card',
	activeItem: 0, 
	autoScroll : false,
	cls:'CourseDashletCLS dashlet horizontalScrollingFixed',
	loadDashlet :function(){
		var this$=this;
		var view= this.layout.getActiveItem();
		ATTENDANCE_ENTRY_PERMISSIONS: Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES')
		if(view.xtype=='griddashlet' || view.xtype=='columnchartdashlet'){
			var store= view.getStore();
			var extraparams=this$.getParams();
			var atype=[]
			userId = this$.getCurrentlyLoggedInDashletUser().id;
			academyLocationId = this$.getUserCurrentAcademyLocation();
			Ext.Ajax.request({
				type : 'rest',
				async: false,
				url : SERVERURL.GET_SESSION_VALUE_BY_ACA_LOCATION,
				params : {
					academyLocatonId : academyLocationId
				},
				method : 'GET',
				success : function(f, action) {
					if(isNullOrEmpty(f.responseText))
					{
						showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('ATTENDANCE_SETTING_NOT_DONE'));	 
					}else{
						var res = Ext.JSON.decode(f.responseText);
						    Ext.each(res, function(data) {
	              				attendanceType.push(data.studentAttendanceType);
	              			 });
						//studentAttendanceType = data.studentAttendanceType;
					}
				}
			});
			if(Ext.Array.contains(attendanceType, 'COURSE_LEVEL') || Ext.Array.contains(attendanceType, 'Course Level')){
				studentAttendanceType="COURSE_LEVEL";
			}else if(Ext.Array.contains(attendanceType, 'COMPLETE_DAY') || Ext.Array.contains(attendanceType, 'Complete Day')){
				studentAttendanceType="COMPLETE_DAY";
			}else if(Ext.Array.contains(attendanceType, 'MULTIPLE_SESSION') || Ext.Array.contains(attendanceType, 'Multiple Session')) {
				studentAttendanceType="COMPLETE_DAY";
			}
			store.getProxy().extraParams = {
				userId: userId,
				attendancetype : studentAttendanceType
			};
			store.load({params:extraparams,
				callback: function(rec, operation, success) {
					if(rec.length==0){
						this$.layout.setActiveItem(0);
					}
				}
			});
		}
	},
	defaults: {
		cls:'panelNoSpace',
		xtype:'griddashlet'
	},

	items:[{
		//model:'Academia.model.programCourseDashboard.CourseAttendanceGridModel',.
		fields:['courseName','sectionName','courseVariantName','totalSessions','totalAssignments','totalStudents', 'courseId','courseVariantId','sectionId','periodId','studentAttendanceType',
		        'programId','batchId', 'studentIds','Schedule','markAttendance','markEntry','message','componentId','childCourseId','whetherMarkEntry','academicTermId','sessionDate'],
		        url : SERVERURL.GET_COURSE_DASHLET,
		        addPagingToolbar : true,
		        /*viewConfig: {
		            stripeRows: CONSTANTS.STRIPEROWS,
		            getRowClass: function(record, rowIndex, rowParams, store){
		            	//if(rowIndex == 7){
		            		return "abc";
		            	//}
		            	
		            }
		        },*/
		        columns : [{
		        	text : getCommonTranslation('COURSE_NAME'),
		        	dataIndex: 'courseName',
		        	sortable : true,
		        	flex:1
		        }, {
		        	text : getCommonTranslation('SECTION'),
		        	dataIndex : 'sectionName',
		        	sortable : true,
		        	flex:1,
		        	hidden:true
		        }, {
		        	text : getCommonTranslation('COURSE_VARIANT'),
		        	dataIndex : 'courseVariantName',
		        	sortable : true,
		        	flex:1
		        },{
		        	text : getCommonTranslation('NO_OF_STUDENT'),
		        	dataIndex: 'totalStudents',
		        	sortable : true,
		        	tpl: '<a>{totalStudent}</a>',
		        	renderer:function(value){
		        		if(value>0){
		        			return  '<a href="#">'+value+'</a>';
		        		}else{
		        			return value;
		        		}
		        	},
		        	flex:1
		        },{
		        	text : getCommonTranslation('SCHEDULE'),
		        	dataIndex: 'Schedule',
		        	sortable : true,
		        	renderer: function(value) {
		        		value="<a href='#'>View</a>"; 
		        		return value;
		        	},
		        	flex:1
		        },{
		        	text : getCommonTranslation('SESSIONS'),
		        	dataIndex: 'totalSessions',
		        	sortable : true,
		        	tpl: '<a>{totalSessions}</a>',
		        	renderer:function(value){
		        		if(value>0){
		        			return  '<a href="#">'+value+'</a>';
		        		}else{
		        			return value;
		        		}
		        	},
		        	flex:1
		        },{
		        	text : getCommonTranslation('Assignments'),
		        	dataIndex: 'totalAssignments',
		        	sortable : true,
		        	tpl: '<a>{totalAssignment}</a>',
		        	renderer:function(value){
		        		if(value>0){
		        			return  '<a href="#">'+value+'</a>';
		        		}else{
		        			return value;
		        		}
		        	},
		        	flex:1
		        },{
		        	text : getCommonTranslation('ATTENDANCE'),
		        	dataIndex: 'markAttendance',
		        	sortable : true,
		        	//tpl:"<div class='list-row-selected'> </div>",
		        	renderer:function(val,metadata,record,rowIndex,colIndex,store,view){
		        		colIndex
		        		try{
		        			var grid = Ext.ComponentQuery.query('coursedashlet')[0];
		        		}
		        		catch(e){
		        			var grid = view.up().up();
		        		}
		        		if(grid.getCode()){
		        			if(studentAttendanceType == "COMPLETE_DAY"){
		        				return '';
		        			}else{
		        				if(!isNullOrEmpty(record.data.sessionDate)){
		        					var str = getProgramandcourseTranslation('COURSE_DASHLET_ATTENDANCE_TOOLTIP');
		        					metadata.tdAttr = 'data-qtip="' + Ext.htmlEncode(str) + '"';
		        					metadata.style = 'text-align: center;';
		        					metadata.tdCls = 'list-row-selected'
		        						return val="<div><a href='#'>Capture</a></div>";
		        				}else{
		        					return val="<div class='list-row-centerAlign'><a href='#'>Capture</a></div>";
		        				}
		        			}
		        		} else {
		        			return '';
		        		}
		        	},
		        	flex:1
		        },{
		        	text : getCommonTranslation('MARKS_ENTRY'),
		        	dataIndex: 'markEntry',
		        	sortable : true,
		        	renderer: function(val,rec,record,rowIndex,colIndex,store,view) {
		        		if(record.data.whetherMarkEntry){
		        			value="<a href='#'>Enter Marks</a>"; 
			        		return value;
		        		} else {
		        			return '';
		        		}
		        	},
		        	flex:1
		        }/*,{
		        	text : getCommonTranslation('Message'),
		        	dataIndex: 'message',
		        	sortable : true,
		        	hidden:true,
		        	renderer: function(value) {
		        		value="<a href='#'>Send</a>"; 
		        		return value;
		        	},
		        	flex:1
		        }*/],
		        listeners:{
		        	activate:function(portlet){
		        		var coursedashlet=portlet.up('coursedashlet');
		        		var grid = coursedashlet.getLayout().getActiveItem();
		        		coursedashlet.addExportToPdf(coursedashlet);
		        		coursedashlet.activeTab = 1;
		        		if(studentAttendanceType == "COMPLETE_DAY" || studentAttendanceType == "COMPLETE DAY"){
		        			grid.columns[7].setVisible(false);
		        		}
		        		coursedashlet.removeGraphViewButton(coursedashlet);
		        		coursedashlet.addExportToPdf(coursedashlet,portlet);
		        		coursedashlet.addExportToExcel(coursedashlet,portlet);
		        		portlet.doLayout();
		        	},
		        	deactivate:function(portlet){
		        		var coursedashlet=portlet.up('coursedashlet');
		        		coursedashlet.removeGraphViewButton(coursedashlet);
		        		coursedashlet.removeExportToPdf();
		        		coursedashlet.removeExportToExcel();
		        	},
		        	cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e,eopts){
		        		var studentCountGrid = View.up('grid');
		        		var columnName = studentCountGrid.columnManager.columns[ColIdx].dataIndex;
		        		if (e.target.tagName == 'A') {
		        		if(columnName == 'totalStudents') {
		        			var selectedRecord = studentCountGrid.getSelectionModel().getSelection()[0];
		        			var courseVariantId = selectedRecord.get('courseVariantId');
		        			var periodId = selectedRecord.get('periodId');
		        			var sectionId = selectedRecord.get('sectionId');
		        			var courseId = selectedRecord.get('courseId');
		        			if(!isNullOrEmpty(courseVariantId)) {
		        				var coursedashlet=studentCountGrid.up('coursedashlet');
		        				coursedashlet.params ={ courseVariantId : courseVariantId};
		        				coursedashlet.getLayout().setActiveItem(2);

		        				var store = coursedashlet.getLayout().getActiveItem().getStore();
		        				store.getProxy().extraParams = {
		        					courseVariantId : courseVariantId,
		        					periodId : periodId,
		        					sectionId : sectionId,
		        					courseId  : courseId,
		        					attendancetype : studentAttendanceType

		        				};
		        				store.load();
		        			}
		        		}
		        		if(columnName == 'totalAssignments') {
		        			var selectedRecord = studentCountGrid.getSelectionModel().getSelection()[0];
		        			var courseVariantId = selectedRecord.get('courseVariantId');
		        			var courseId = selectedRecord.get('courseId');
		        			var programId = selectedRecord.get('programId');
		        			var batchId = selectedRecord.get('batchId');
		        			var sectionId = selectedRecord.get('sectionId');
		        			var periodId = selectedRecord.get('periodId');
		        			if(!isNullOrEmpty(courseVariantId)) {
		        				var tabTitle = "Homework & Assignments";
		        				var assignmentController = Academia.app.getController('Academia.controller.facultyportal.FacultyHomeworkAssignmentController');
		        				var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
		        				personController.addContentPanelTab(tabTitle, 'facultyhomeworkliststructure', null, null, null, null, null);
		        				personController.loadAssignments(assignmentController, selectedRecord, userId)
		        			}
		        		}
		        		if(columnName == 'markAttendance') {
		        			var selectedRecord = studentCountGrid.getSelectionModel().getSelection()[0];
		        			var courseVariantId = selectedRecord.get('courseVariantId');
		        			var courseId = selectedRecord.get('courseId');
		        			var attendanceDashletWin= this.up('window');
		        			if(!isNullOrEmpty(courseVariantId)) {
		        				if(!isNullOrEmpty(attendanceDashletWin)){
		        					attendanceDashletWin.close();
		        				}
		        				 var permissionsMap = new Ext.util.HashMap();
		        				 permissionsMap= Academia.utilities.accessControl.FeaturePrivilegeManager.getFeaturePrivilegesMap('ATTENDANCE_ENTRY_FACULTY_PORTAL_PRIVILEGES')
		        				var associatedAcadLocationIds = new Array();
	        			    	associatedAcadLocationIds.push(this$.getCurrentAcademyLocation());
	        					var permissionList = Academia.utilities.accessControl.AccessControlManager.checkFeaturePrivelages(associatedAcadLocationIds, permissionsMap);
	        					if(Ext.Array.contains(permissionList, 'COURSE_WISE') ){
	        						var tabTitle = getMegaMenuTranslation('FP_MARK_ATTENDANCE');
	 		        				var attendanceController = Academia.app.getController('Academia.controller.facultyportal.attendance.FacultyCaptureAttendanceController');
	 		        				var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
	 		        				var contentPanel = personController.getContentPanel(); //get hold of the content panel where we are adding all the tabs
 		        			        var newTab = personController.getTabReferenceByTabTitle(tabTitle);
 		        			        if(newTab){
 		        			        	contentPanel.remove(newTab, true);
 		        			            //newTab.close();
 		        			        }
 		        					personController.addContentPanelTab(tabTitle, 'facultycaptureattendancemasterstructure', null, null, null, null, null);
	 		        				Ext.defer(function() {
	 		        					personController.getContentPanelActiveTab().academicTermId = selectedRecord.data.academicTermId;
	 		        					personController.loadMarkAttendance(attendanceController, selectedRecord, academyLocationId, userId, studentAttendanceType);
	 		        				},500);
	        					}else{
	        						showWarningMessage(getCommonTranslation('ALERT'),getProgramandcourseTranslation('You do not have permission to open this tab'));
	        					}
		        				
		        				}
		        		}
		        		if(columnName == 'markEntry') {
		        			var selectedRecord = studentCountGrid.getSelectionModel().getSelection()[0];
		        			var courseVariantId = selectedRecord.get('courseVariantId');
		        			var courseId = selectedRecord.get('courseId');
		        			var courseDashletWin= this.up('window');
		        			if(!isNullOrEmpty(courseVariantId)) {
		        				if(!isNullOrEmpty(courseDashletWin)){
		        					courseDashletWin.close();
		        				}
		        				var tabTitle = "Mark Entry";
		        				var entryController = "";
		        				var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
		        				personController.addContentPanelTab(tabTitle, 'manageevalresultmasterstructure', null, null, null, null, null);
		        				personController.loadMarkEntry(entryController, selectedRecord, academyLocationId);
		        			}
		        		}
		        		if(columnName == 'totalSessions') {
		        			var selectedRecord = studentCountGrid.getSelectionModel().getSelection()[0];
		        			var courseVariantId = selectedRecord.get('courseVariantId');
		        			var courseId = selectedRecord.get('courseId');
		        			var programId = selectedRecord.get('programId');
		        			var batchId = selectedRecord.get('batchId');
		        			var sectionId = selectedRecord.get('sectionId');
		        			var periodId = selectedRecord.get('periodId');
		        			if(!isNullOrEmpty(courseVariantId)) {
		        				var tabTitle = getCommonTranslation("COURSE_SESSION_DAIRY");
		        				var sessionController = Academia.app.getController('Academia.controller.coursesessiondiary.CourseSessionDiaryController');
		        				var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
		        				 var portalId = this$.getCurrentLoggedPortalId();
	                			   if(portalId == 2) {
	                				personController.addContentPanelTab(tabTitle, 'coursesessiondiaryfacultyportalstructure', null, null, null, null, null);
	   		        				personController.loadSessionReportFacultyPortal(sessionController, selectedRecord, userId); 
	                			   }else{
	                				personController.addContentPanelTab(tabTitle, 'coursesessiondiarystructure', null, null, null, null, null);
		   		        			personController.loadSessionReport(sessionController, selectedRecord, userId);
	                			   }
		        			}
		        		}
		        		if(columnName == 'Schedule') {
		        			var selectedRecord = studentCountGrid.getSelectionModel().getSelection()[0];
		        			if(!isNullOrEmpty(userId)) {
		        				var tabName= getMegaMenuTranslation('FP_MASTER_SHEDULE');
		        				var scheduleController = Academia.app.getController('Academia.controller.portal.MasterScheduleController');
		        				var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
		        				var contentPanel =scheduleController.getContentPanel(); //get hold of the content panel where we are adding all the tabs
		        				var getTab = null;
		        				for(var i =0 ;i<contentPanel.items.length;i++){
		        					if(contentPanel.items.items[i].title == tabName){
		        						getTab= contentPanel.items.items[i];
		        					} 
		        				}
		        				if(getTab!=null){
		        					contentPanel.remove(getTab, true);
		        				}
		        				personController.addContentPanelTab(tabName, 'masterschedulefacultysearchstructure', null, null, null, null, null);
		        				scheduleController.getMasterschedulefacultysearchfilter().down('#dashletCourseVariantId').setValue(selectedRecord.get('courseVariantId'));
		        			}
		        		}
		        		/*if(columnName == 'message') {
		        			var selectedRecord = studentCountGrid.getSelectionModel().getSelection()[0];
		        			if(!isNullOrEmpty(userId)) {
		        				var personController =  Academia.app.getController('Academia.controller.attendance.PendingAttendanceController');
		        				personController.openSendMessageDashletWindow(selectedRecord, studentCountGrid, null);
		        			}
		        		}*/
		        		}
		        	}
		        }
	},{
		xtype:'columnchartdashlet',
		xAxesCategoryField :['courseName','sectionName', 'courseVariantName'],
		yAxesNumericField : 'count',
		xAxesCategoryTitle :getCommonTranslation('STUDENT'),
		yAxesNumericTitle :getCommonTranslation('COUNTS'),
		model:'Academia.model.programCourseDashboard.CourseAttendanceGridModel',
		url : SERVERURL.GET_COURSE_DASHLET,
		listeners:{
			activate:function(portlet){
				var coursedashlet=portlet.up('coursedashlet');
				coursedashlet.activeTab = 0;
				coursedashlet.addGridViewButton(coursedashlet);
				coursedashlet.addExportToPng(coursedashlet,portlet);
			},
			deactivate:function(portlet){
				var coursedashlet=portlet.up('coursedashlet');
				coursedashlet.removeGridViewButton(coursedashlet);
				coursedashlet.removeExportToPng();
			}
		}
	},{
		fields:['admissionCode','studentCode','studentName','attendancePercentage','emailId','contactNo','id','personId','progamBatchSeatConfigId','birthDate',{name:'fatherName',type:'string'},{name:'motherName',type:'string'}],
		url : SERVERURL.GET_STUDENT_COURSE_DASHLET,
		addPagingToolbar : true,
		isGridConfigurable: true,
		enableColumnHide: false,
		columns : [{
			text : getCommonTranslation('ADMISSION_ID'),
			dataIndex: 'admissionCode',
			sortable : true,
			flex:1
		}, {
			text : getCommonTranslation('STUDENT_ID'),
			dataIndex : 'studentCode',
			sortable : true,
			flex:1
		},{
			text : getCommonTranslation('STUDENT_NAME'),
			dataIndex : 'studentName',
			sortable : true,
			flex:1
		},{
			text : getCommonTranslation('EMAIL_ID'),
			dataIndex : 'emailId',
			sortable : true,
			flex:1
		},{
			text : getCommonTranslation('CONTACT_NO'),
			dataIndex : 'contactNo',
			sortable : true,
			flex:1
		}, {
			text : getCommonTranslation('DOB'),
			dataIndex : 'birthDate',
			sortable : true,
			flex:1,
			hidden:true,
			renderer:function(value){
	        	if(!isNullOrEmpty(value)){
	        		return dateRender(value);
	        	}
	        	else{
	        		return '';
	        	}
	        }
		}, {
			text : getCommonTranslation('FATHER_NAME'),
			dataIndex : 'fatherName',
			sortable : true,
			flex:1,
			hidden:true
		}, {
			text : getCommonTranslation('MOTHERS_NAME'),
			dataIndex : 'motherName',
			sortable : true,
			flex:1,
			hidden:true
		}/*,{
			text : getCommonTranslation('ATTENDANCE_PERCENTAGE'),
			dataIndex : 'attendancePercentage',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					value=value+"%"; 
				}else{
					value= ''; 
				}
        		return value;
        	},
			flex:1
		}*/],
		listeners:{
			activate:function(portlet){
				var coursedashlet=portlet.up('coursedashlet');
				coursedashlet.addExportToPdf(coursedashlet,portlet);
				coursedashlet.addExportToExcel(coursedashlet,portlet);
				var currentGrid = coursedashlet.items.get(2);
				//var currentGridColumns = currentGrid.columns;
				//var currentGridStore = currentGrid.store;
				/*if(studentAttendanceType == "COMPLETE_DAY" || studentAttendanceType == "COMPLETE DAY"){
					currentGrid.columns[5].setVisible(false);
        		}
				else{
					currentGrid.columns[5].setVisible(true);
				}*/
				//coursedashlet.addDataGridConfigureButtonDashlet(coursedashlet);
				coursedashlet.addTool(Ext.create('Ext.panel.Tool',{
					type: 'prev',
					handler: function(btn, target, header, tool){
						header.ownerCt.getLayout().setActiveItem(0);
						header.remove(tool);
						coursedashlet.params={};
						// reset the page param after going previous page
						var itemStore = coursedashlet.items.get(2).getStore();
						itemStore.currentPage = 1;
						coursedashlet.loadDashlet();
					}
				}));
				coursedashlet.header.down('#dataGridConfigureBtn').setVisible(true);
			},
			deactivate:function(portlet){
				var coursedashlet=portlet.up('coursedashlet');
				coursedashlet.removeExportToPdf();
				coursedashlet.removeExportToExcel();
				coursedashlet.removeDataGridConfigureButtonDashlet(coursedashlet);
			},
		}
	},
	/*,{
		xtype: 'image',
		width: '100%',
		height: '100%',
		frame : false,
		src: CONSTANTS.NO_DATA_DISPALY_DASHBORD_IMAGE_SRC,//'resources/images/no_data_to_display.png',
		listeners:{
			activate:function(portlet){
				var coursedashlet=portlet.up('coursedashlet');
				coursedashlet.addExportToPdf(coursedashlet);
				coursedashlet.activeTab = 1;
				coursedashlet.addGraphViewButton(coursedashlet);
				coursedashlet.addExportToPdf(coursedashlet,portlet);
				coursedashlet.addExportToExcel(coursedashlet,portlet);
			},
			deactivate:function(portlet){
					var coursedashlet=portlet.up('coursedashlet');
					coursedashlet.removeGraphViewButton(coursedashlet);
					coursedashlet.removeExportToPdf();
					coursedashlet.removeExportToExcel();
			}
		}
	}*/]
});
