/**
 * @author trupti.paoneker
 * 
 * This component is used for to show window with new bank master details. 
 */
Ext.define('Academia.view.documentmanagement.DocumentMasterFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.documentmasterformwindow',
    modal: true,
    resizable: false,
    title: getTranslation('PLACEMENT_DOCUMENT_MASTER'),
    margin: 0,
    items: [{
        xtype: 'idgeneratorformwin',
        itemId: 'documentMasterFormItemId',
        plugins: "formlabelrequired",
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'hidDocumentMasterId',
            name: 'id'
        },   {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                fieldLabel: getCommonTranslation('ITEM_CODE'),
                xtype: 'textfield',
                itemId: 'codeItemId',
                name: 'code',
                labelAlign: 'top',
                maxLength: 255,
                allowBlank: false
            }, {
                fieldLabel: getCommonTranslation('ITEM_VALUE'),
                xtype: 'textfield',
                itemId: 'itemValueItemId',
                name: 'value',
                labelAlign: 'top',
                maxLength: 255,
                allowBlank: false
            }]
        },   
        {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
            	
				xtype: 'multiselectcombofield',
				name: 'dmfiletype',
				itemId:'dmfiletype',
				fieldLabel: getCommonTranslation('FILE_TYPE'),
				store:'documentmanagement.DocumentMasterFileTypeStore',
	    		valueField: 'id',
	    		forceSelection:true,
	    		displayField: 'value',
	    		cls:'multiBrandCampusCls'
			},{
				
                fieldLabel: getCommonTranslation('MAX_SIZE_IN_KB'),
                xtype: 'numberfield',
                itemId: 'dmmaxsize',
                name: 'dmmaxsize',
                labelAlign: 'top',
                maxLength:9,
		        maxValue:2147483647,
		        //disabled:true
            }]
        },
        {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                fieldLabel: getCommonTranslation('ITEM_CODE_IN_OTHER_LANGUAGE'),
                xtype: 'textfield',
                itemId: 'codeInOtherLanguage',
                name: 'codeInOtherLanguage',
                labelAlign: 'top',
                maxLength: 255,
                allowBlank: true
            }]
        },
        {
            xtype: 'label',
            html: "<span style='font-weight: bold; text-decoration: underline;'>" + getCommonTranslation('APPLICABLE_TO') + "</span>",
            style: {
                marginTop: '15px',
                marginBottom: '15px',
                display:'block'
            },
            width: 226
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'left',
                width: 226
            },
            items: [{
    			xtype: 'checkboxfield',
    			name: 'isApplicableForStudent',
    			itemId:'isApplicableForStudentItemId',
    			boxLabel: getCommonTranslation('STUDENT'),
    			width: 90,
    			boxLabelAlign:'after',
    			labelAlign: 'right',
    			checked:true
            },{
            	xtype: 'checkboxfield',
            	name: 'isApplicableForEmployee',
            	itemId:'isApplicableForEmployeeItemId',
            	boxLabel: getCommonTranslation('EMPLOYEE'),
            	width: 200,
            	boxLabelAlign:'after',
            	labelAlign: 'right',
    			checked:true

            },{
            	xtype: 'checkboxfield',
            	name: 'isApplicableForParent',
            	itemId:'isApplicableForParentItemId',
            	boxLabel: getPersonModuleTranslation('PARENTS_GUARDIANS'),
            	width: 200,
            	boxLabelAlign:'after',
            	labelAlign: 'right',
    			checked:true

            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                itemId: 'btnSaveDocumentMasterForm',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'btnCancelDocumentMasterForm',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});
