Ext.define('Academia.view.documentmanagement.GroupDocumentRequestGrid',{
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.groupdocumentrequestgrid',
	store: 'documentmanagement.DocumentUserRequestGridStore',
	title: getCommonTranslation('URP_USERS'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: 'documentmanagement.DocumentUserRequestGridStore',
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo: true
		}]
	}],
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	tbar: [{
		xtype: 'button',
		itemId: 'sendMsgBtn',
		text:getCommonTranslation('SEND_MESSAGE'),
		tooltip :getCommonTranslation('SEND_MESSAGE')
	},'->',{
		xtype:'displayfield',
		name : 'groupName',
		itemId : 'groupNameDisplayId',
		hidden:true
	}],
	columns: [{
		header: getCommonTranslation('EMPLOYEE_ID'),
		dataIndex: 'employeeCode',
		flex: 1,
		renderer:function(val,rec){
			return rec.record.data.employeeCode;
		}
	}, {
		header: getCommonTranslation('NAME'),
		dataIndex: 'employeeName',
		flex: 1
	}, {
		header: getCommonTranslation('DEPARTMENT'),
		dataIndex: 'departmentName',
		flex: 1,
	}, {
		header: getCommonTranslation('GROUP'),
		dataIndex: 'userGroup',
		flex: 1,
	}, {
		header: getCommonTranslation('USER_TYPE'),
		dataIndex: 'userType',
		flex: 1,
		renderer : function(value, metadata, record) {
			var val = '';
			if(record.data.userGroup=="Faculty"){
				val = value;
			}

			return val;
		}

	}, {
		header: getCommonTranslation('EMPLOYEE_TYPE'),
		dataIndex: 'employeeType',
		flex: 1,
		renderer : function(value, metadata, record) {
			var val = '';
			if(record.data.userGroup=="Other Employee"){
				if(value == 'PART_TIME') {
					val = getCommonTranslation('PART_TIME');
				}else if(value == 'PROBATION') {
					val = getCommonTranslation('PROBATION');
				}else if(value == 'FULL_TIME') {
					val = getCommonTranslation('FULL_TIME');
				}
			}

			return val;
		}

	}, {
		header: getCommonTranslation('DESIGNATION'),
		dataIndex: 'designation',
		flex: 1,
	}, {
		header: getCommonTranslation('REQUESTED_ON'),
		dataIndex: 'requestedOn',
		flex: 1,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header: getCommonTranslation('HW_SUBMISSION_DATE'),
		dataIndex: 'completedOn',
		flex: 1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header: getCommonTranslation('STATUS'),
		dataIndex: 'documentStatus',
		flex: 1,
	},{
		header: getCommonTranslation('DOCUMENT_VIEW'),
		dataIndex: 'documentView',
		flex: 1,
		renderer: function(value, metadata, record) {
			var msg = '<a href="#">' + "View" + '</a>';
			if (!isNullOrEmpty(value) && !isNullOrEmpty(value)) {
				msg = '<a href="#">' + "View" + '</a>';
			}
			return msg;
		}
	}
	],
});