Ext.define('Academia.view.dynamicformrendering.DynamicFormRenderingGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.dynamicformrenderinggrid',
	store : 'dynamicformrendering.DynamicFormRenderingGrid',
	title: getCommonTranslation('DYNAMIC_FORM_RENDERING'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	cls: 'translationGridCls',
	headerFix:{
        headerFix: true,
        portalIdsWithStructure: {
            'dynamicformrenderingstructure':1
        }
    },
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			store : 'dynamicformrendering.DynamicFormRenderingGrid',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    },/*{
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, */{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    },
    {
	    xtype : 'splitbutton',
	    itemId:'spBtnMoreActions',
	    text : getCommonTranslation('MOREACTIONS'),
	    menu:[{
			text:getCommonTranslation('COPY_TO_OTHER_ACADLOC'),
			itemId:'copyAcademyLocation'
		    }],
	    listeners: { click: function() { this.showMenu(); } }
	}],
	columns : [{
		header :getCommonTranslation('ACADEMYLOCATION'),
		dataIndex : 'academyLocationName',
		flex:1
	},{
		header : getCommonTranslation('SCREENNAME'),
		dataIndex : 'formScreenName',
		flex:1
	},{
		header : getCommonTranslation('SCREENMODE'),
		dataIndex : 'formScreenMode',
		flex:1
	},{
		header : getCommonTranslation('LANGAUGE'),
		dataIndex : 'languageName',
		flex:1
	}]
});
