/**
 * Rajkumar
 */

Ext.define('Academia.view.enquiry.admission.AdmissionReqmntDetailGrid_1', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.admissionreqmntdetailgrid',
    store : 'enquiry.admission.AdmissionReqmntStore',
	border: true,
	sortableColumns:false,
	enableColumnHide: false,
	enableColumnMove: false,
	enableColumnResize: false,
	autoScroll: true,
	id:'admissionrqmnt_grid',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
            emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			store : 'enquiry.admission.AdmissionReqmntStore',
			displayInfo : true
		}]
	}],
	tbar : [{
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		 xtype: 'button',
         itemId: 'btnView',
         tooltip: getCommonTranslation('VIEW'),
         iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDeleteTopic',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns : [{
		hidden:true,
		dataIndex : 'id'
	},{
		header : getCommonTranslation('ACADEMY'),
		dataIndex : 'academy',
		flex : 1,
		renderer : function(value){
			return value.value;
		}
	},{
		header : getCommonTranslation('LOCATION'),
		dataIndex : 'location',
		flex : 1,
		renderer : function(value){
			return value.value;
		}
	},{
		header : getCommonTranslation('PROGRAMS_ENQUIREY_FOR_GRID'),
		dataIndex : 'program',
		flex :1,
		renderer : function(value){
			return value.value;
		}
	},{
		header : getCommonTranslation('ACADEMIC_BATCH'),
		dataIndex:'batch',
		flex : 1,
		renderer : function(value){
			return value.value;
		}
	},{
		header : getCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatType',
		flex : 1,
		renderer : function(value){
			return value.value;
		}
	},{
		header : getCommonTranslation('RESERVATION_CATEGORY'),
		dataIndex:'reservationCategoryCode',
		flex : 1
	},{
		header:getCommonTranslation('CLOSER_DATE'),
		dataIndex:'closureDate',
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header:getCommonTranslation('STATUS'),
		dataIndex:'status',
		flex : 1
	}]
});
