/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.enquiry.assignhours.EnquiryAssignHoursGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.enquiryassignhoursgrid',
	store : 'enquiry.assignhours.AssignHoursStore',
	title:getCommonTranslation('ENQUIRIES_ASSIGNMENT_HOURS'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'enquiry.assignhours.AssignHoursStore',
			emptyMsg :getCourseTxCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}
	],
	tbar : [ {
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH
	},{
	     xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],

	columns : [{
				header : getCommonTranslation('ACADEMY'),
				dataIndex : 'academy',
				flex:1,
				renderer:function(value){
					if(value!=null){
						return value.value;
					}
				}
				
			},{
				header : getCommonTranslation('LOCATION'),
				dataIndex : 'location',
				flex:1,
				renderer:function(value){
					if(value!=null){
						return value.value;
					}
				}
			},{
				header : getCommonTranslation('FROM_TIME'),
				dataIndex : 'workingFromTime',
				flex:1,
				renderer: function(time) {
		            return timeRender(time);
		        }
				
			},{
				header : getCommonTranslation('TO_TIME'),
				dataIndex:'workingToTime',
				flex:1,
				renderer: function(time) {
		            return timeRender(time);
		        }
	        }]

});