/**
 * @author Rajkumar.patidar
 */

Ext.define('Academia.view.enquiry.dashboard.GroupBarChartForCountofEnquiry' ,{
	extend: 'Ext.chart.Chart',
    style: 'background:#fff',
    alias : 'widget.groupbarchartforcountofenquiry',
    animate: true,
    legend : {
		position : 'right'
	},
    initComponent: function() {
        var this$ = this;
        var categoryField = !isNullOrEmpty(this.xAxesCategoryField)?this.xAxesCategoryField:'category';
        var groupField = !isEmpty(this.groupField)?this.groupField:'group';
        var numericTitle = !isNullOrEmpty(this.yAxesNumericTitle)?this.yAxesNumericTitle: getCommonTranslation('NUMERIC_TITLE');
        var categoryTitle = !isNullOrEmpty(this.xAxesCategoryTitle)?this.xAxesCategoryTitle:getCommonTranslation('CATEGOTY_TITLE');
        var chartStore = null;
        if(!isNullOrEmpty(this.store)){
        	chartStore = Ext.create(this.store);
        }else{
        	chartStore = Ext.create('Ext.data.JsonStore',{
        		fields: ['category', 'group'],
        		data: [{
        			number :0,
        			category : 'Category',
        			group : 'Group'
        		}]
        	});
        }
        Ext.apply(this$, {
        	store: chartStore,
        	axes: [{
                type: 'Numeric',
                position: 'left',
                fields: groupField,
                minimum: 0,
                label: {
                    renderer: Ext.util.Format.numberRenderer('0,0')
                },
                grid: true,
                title: numericTitle
            }, {
                type: 'Category',
                position: 'bottom',
                fields: categoryField,
                title: categoryTitle,
                label: {
                    rotate: {
                        degrees: -45
                    }
                }
            }],
            series: [{
                type: 'column',
                axis: 'left',
                xField: categoryField,
                yField: groupField,
                groupGutter:0,
                tips: {
                    trackMouse: true,
                    height: 28,
                    renderer: function(storeItem, item) {
                    	var count = 0;
                    	if(item.yField == 'Admission') {
                    		count = storeItem.data.Admission;
                    	} else if(item.yField == 'Corporate') {
                    		count = storeItem.data.Corporate;
                    	} else if(item.yField == 'Counselling') {
                    		count = storeItem.data.Counselling;
                    	}
                    	var tipTitle = storeItem.get(categoryField) + ': ' + count;
                    	var titleLength = (tipTitle.length)*10;
                    	this.setWidth(titleLength);
                    	this.setTitle(tipTitle);
                    	item.sprite.el.dom.style.cursor="pointer";
                    }
                },
                renderer: function(sprite, storeItem, barAttr, i, store) {
                	if(store.getCount() < 20){
	                	return Ext.apply(barAttr, {
	                        width: 20,
	                        x: Math.max(barAttr.x, barAttr.x + (barAttr.width - 20) / 2)
	                    });
	                	/*barAttr.width = 20;
	              	  	return barAttr;*/
                	}
                	else{
                		return Ext.apply(barAttr, {
	                        width: 10,
	                        x: Math.max(barAttr.x, barAttr.x + (barAttr.width - 10) / 2)
	                    });
                	}
                }
            }]/*,
            listeners: {
                refresh: function(chart) {
                	var count = chart.getStore().getCount();
                	if(count>0){
                		var chartWidth = (count * 40 * 4) + 60; 
                		chart.setWidth(chartWidth);
                		chart.doComponentLayout();
                	}
                }
            }*/
        });

        this$.callParent(arguments);
    }
});
