/**
 * Rajkumar
 */

Ext.define('Academia.view.enquiry.exam.ExamDetailForm', {
	extend: 'Ext.window.Window',
	//extend:'Academia.view.common.CustomForm',
	//extend: 'Academia.view.common.CustomFieldForm',
	alias: 'widget.examdetailform',
	autoScroll: true,
	title:getCommonTranslation('EXAMTITLE'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	items: [{
		xtype: 'customfieldform',
		customFieldEntity:CONSTANTS.ENQ_EXAM_DETAIL_CUSTOM_FIELD,
		columns: 1,
		//bodyPadding: '5 5 5 5',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype: 'radiogroup',
			name: 'programExam',
			itemId:'ED_radioBtn',
			fieldLabel : getCommonTranslation('PROGRAM_EXAM'),
			layout: 'vbox',
			items:[
			       { boxLabel: getCommonTranslation('CURRENTLY_PURSUING'), name: 'radio', inputValue: '1',checked:true},
			       { boxLabel: getCommonTranslation('PREVIOUS_PASSED_EXAM'), name: 'radio', inputValue: '2'}
			       ]
		},{	
			xtype: 'customcombobox',
			name: 'program',
			itemId: 'programId',
			fieldLabel: getEnquiryTranslation("PROGRAM"),
			// emptyText: getCommonTranslation('SELECT'),
			store:'enquiry.exam.ProgramStore',
			displayField:'value',
			valueField:'id',
			allowBlank:false,
			typeAhead:true,
			forceSelection:true
		},{
			xtype:'hidden',
			name:'programCodeExamDeatil'
		},{
			xtype: 'textfield',
			name: 'programConductedBy',
			fieldLabel: getEnquiryTranslation("PROGRAM_CONDUCT_BY"),
			allowBlank:false,
			maxLength:95
		},{
			xtype: 'numberfield',
			name: 'programYear',
			itemId: 'programYear',
			fieldLabel: getEnquiryTranslation("PROGRAM_YEAR"),
			hideTrigger:true,
     	    mouseWheelEnabled:false,
     	    allowBlank: false,
     	    allowDecimals:false,
			enforceMaxLength : true,
     	    minValue:0,
     	    maxLength: 4,
     	    minLength:4
		},{
			xtype: 'textfield',
			name: 'examResult',
			hidden:true,
			fieldLabel: getEnquiryTranslation("EXAM_RESULT"),
			maxLength:10
		}, {
			xtype: 'statusCombos',
			itemId:'examStatusDetail',
			hidden:true,
			editable: false,
			name: 'examStatus'	
		}, {
			border : false,
			layout : {
				type : 'hbox',
				width : '100%'
			},
			style:{
				marginLeft:'0px'
			},
			items: [{

				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'examdetail_submitbuttonId',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'examdetail_cancelbuttonId',
				scale: CONSTANTS.BUTTONSIZE

			}]
		}]
	}]     
});