/**
 * Rajkumar
 */

Ext.define('Academia.view.enquiry.exam.ExamDetailGrid', {
	//extend : 'Ext.grid.Panel',
	 extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	store : 'enquiry.exam.ExamDetailStore',
	alias : 'widget.examdetailgrid',
	border: true,
	id:'examDetail_grid',
	title: getCommonTranslation('LIST_OF_EXAM_DETAILS'),
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
            store : 'enquiry.exam.ExamDetailStore',
		    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
		    displayInfo : true
		}]
	}],
    initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	tbar : [{
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH

	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH

	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}],
	columns : [{
		hidden:true,
		dataIndex : 'id'
	},{
		header : getEnquiryTranslation("EXAM_PROGRAM"),
		dataIndex : 'enqProgramMaster',
		flex : 1,
		renderer : function(value){
			return value.value;
		}
	},{
		header : getEnquiryTranslation("PROGRAM_YEAR"),
		dataIndex : 'programYear',
		flex : 1
	},{
		header : getEnquiryTranslation("EXAM_RESULT"),
		dataIndex : 'examResult',
		flex : 1
	},{
		header : getEnquiryTranslation("PROGRAM_CONDUCT_BY"),
		dataIndex:'programConductedBy',
		flex : 1	         
	},{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'examStatus',
		flex : 1,
		renderer : function(value){
			if(value=='Pur'){
				return getCommonTranslation('PURSUING');
			} else {
				return value;
			}
		}
	}]

});