Ext.define('Academia.view.examCenter.assignSequence.AssignAssessmentMethodGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.assignassessmentmethodgrid',

    width: 500,
    height: 250,
    modal: true,
    border: true,
    autoScroll: true,

    store: 'examCenter.AssignSequence.AssignSeqenceMethodCountStore',

	viewConfig: {
	        stripeRows: CONSTANTS.STRIPEROWS,
	        emptyText:getCommonTranslation('EMPTY_MESSAGE'),
	        deferEmptyText: false,
			listeners: {
				        refresh: function(view) {
				            view.el.dom.style.overflowX = 'hidden';  // Remove Horizontal scoller
				        }
				    }
	    },

    columns: [{
        header: 'Assessment Method',
        dataIndex: 'value',
        flex: 1,
        sortable: true,
		renderer: function(val, rec) {
		            if (!isNullOrEmpty(val)) {
		               return val;
		            }
		        }
    }],
	
	dockedItems: [{
		           xtype: 'toolbar',
		           dock: 'bottom',
		           items: [{
		               xtype: 'custompagingtoolbar',
		               plugins: ['pagesize'],
		               store: 'examCenter.AssignSequence.AssignSeqenceMethodCountStore',
		               emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
		               displayInfo: true
		           }]
		       }],
});
