/**
 * @author Manas
 * @description Exam Block Listing Grid (Simple + Direct Data Binding)
 */
Ext.define('Academia.view.examblock.ExamBlockListingGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.examblocklistinggrid',
	store: 'assessmentSchedule.examBlockGridStore',
	title: getExaminationTranslation('LIST_OF_EXAM_BLOCKS'),
    border: true,
    frame: false,
	refreshStoreData:true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },

    selModel: {
        mode: 'SINGLE',
        showHeaderCheckbox: true,
        allowDeselect: false,
        checkOnly: true
    },

    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'assessmentSchedule.examBlockGridStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],

    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },

    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
		}, {
			xtype: 'button',
			itemId: 'btnDelete',
			cls: 'CustomToolbarBtnReject',
			tooltip: getCommonTranslation('DELETE'),
			glyph: ICONGLYPH.DELETEGLYPH
		},		{
		    xtype : 'splitbutton',
		    itemId:'spBtnMoreActions',
		    text : getCommonTranslation('MOREACTIONS'),
		    menu:[{
		        text:getExaminationTranslation('Apply To'),
		        itemId:'approveItemId'
		    },{
		        text:getExaminationTranslation('Active / Inactive'),
		        itemId:'activeInactiveItemId'
		    }],
		    listeners: { 
		        click: function() { 
		            this.showMenu(); 
		        } 
		    }
		}],

	columns: [{
		header: getExaminationTranslation('EXAM_BLOCK_CODE'),
        dataIndex: 'code',
        flex: .15,
        sortable: true
    }, {
        header: getExaminationTranslation('EXAM_BLOCK_NAME'),
        dataIndex: 'name',
        flex: .20,
        sortable: true
    }, {
        header: getExaminationTranslation('FROM_DATE'),
        dataIndex: 'fromDate',
        flex: .15,
        sortable: true,
		hidden:true
    }, {
        header: getExaminationTranslation('TO_DATE'),
        dataIndex: 'tillDate',
        flex: .15,
        sortable: true,
		hidden:true
    }, 
	/*{
        header: getCommonTranslation('EXAM_CENTER'),
        dataIndex: 'examCenterName',
        flex: .20,
        sortable: true
    }, 
	*/{
        header: getCommonTranslation('STATUS'),
        dataIndex: 'status',  
        flex: .15,
        sortable: true
    }]
});