/**
 * @author Deepika P
 */
Ext.define('Academia.view.examconcession.ExamConcessionApplyToWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.examconcessionapplytowindow',
	modal : true,
	resizable:false,
	autoScroll:false,
	title: getExaminationTranslation('APPLY_TO'),
	height: 320,
	width: 535,
	frame: true,
	items:[{
		xtype : 'form',
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		plugins : "formlabelrequired",
		items : [{
			xtype : 'fieldcontainer',
			width : 'auto',
			defaults : {
				labelAlign : 'top',
				width : 462
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'textfield',
				name : 'examConcessionName',
				allowBlank : true,
				fieldLabel : getExaminationTranslation('EXAM_CONCESSION_NAME'),
				readOnly: true
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			defaults : {
				labelAlign : 'top',
				width : 462
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'textfield',
				name : 'academyLocationName',
				allowBlank : false,
				fieldLabel : getExaminationTranslation('ACADEMY_LOCATION'),
				readOnly: true
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			defaults : {
				labelAlign : 'top',
				width : 226
			},
			layout : {
				type : 'hbox'
			},
			items : [{
				xtype : 'textfield',
				name : 'programName',
				allowBlank : false,
				fieldLabel : getExaminationTranslation('PROGRAM'),
				readOnly: true
			},{
				xtype : 'textfield',
				name : 'batchName',
				allowBlank : false,
				fieldLabel : getExaminationTranslation('BATCH'),
				readOnly: true
			}]
		},{
			xtype : 'fieldcontainer',
			width : '100%',
			cls : 'windowBtnPos',
			items : [{
				xtype : 'button',
				style:{
					marginTop: '10px'
				},
				itemId : 'applyToWindowCancelBtn',
				text : getCommonTranslation('CANCEL'),
				ui : 'CustomBtnCancel',
				scale : CONSTANTS.BUTTONSIZE
			} ]
		} ]
	}]
});