Ext.define('Academia.view.examexecution.EvaluationGroupCourseGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.evaluationgroupcoursegrid',

    autoScroll: true,
    border: true,

    columns: [{
        header: getExaminationTranslation('COURSE_CODE'),
        dataIndex: 'courseName',
        flex: 1,
        renderer: function (v, m, r) {
            var c = r.get('courseVariantCode');
            return (v && c) ? v + ' / ' + c : (v || c || '');
        }
    }],

    viewConfig: {
        emptyText: 'No courses found',
        deferEmptyText: false,
        listeners: {
            refresh: function(view) {
                view.el.dom.style.overflowX = 'hidden';   // Horizontal scroll hide
            }
        }
    }
});
