/**
 * @author
 * Manas
 */
Ext.define('Academia.view.examexecution.StudentRegisterForEvalGroupGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.studentregisterforevalgroupgrid',

    title: getMegaMenuTranslation('REGISTER_FOR_ASSESSMENT_GROUP'),
    titleAlign: 'center',
    autoScroll: true,

    store: 'RegEGStores.RegEGApplicationStore',
	
	selModel: {
	    selType: 'checkboxmodel',
	    mode: 'SINGLE',         
	    allowDeselect: true,     
	    checkOnly: true,
	    showHeaderCheckbox: false 
	},
	initComponent: function() {
	        var grid=this;                   
	        grid.addExportToolBarItems(grid,false);
	        this.callParent(arguments);     
		},
    tbar: [
        {
            xtype: 'button',
            itemId: 'btnApplyItemId',
            tooltip: getCommonTranslation('APPLY'),
            text:getCommonTranslation('APPLY'),
            disabled: true
        },
        {
            xtype: 'button',
            itemId: 'btnMakePayment',
            tooltip: getCommonTranslation('MAKE_PAYMENT'),
            text: getCommonTranslation('MAKE_PAYMENT'),
            disabled: true
        },'->',
		{
			xtype: 'button',
			itemId: 'downloadForm',
			tooltip: getExaminationTranslation('DOWNLOAD_FORM'),
			text: getExaminationTranslation('DOWNLOAD_FORM')
		}],

    columns: [
        {
            text: getExaminationTranslation('EVAL_GROUP'),
            dataIndex: 'evaluationGroupCode',
            flex: 0.2,
            renderer: function (v) { return v; }
        },
        {
            text: getExaminationTranslation('EVALUATION_PLAN'),
            dataIndex: 'assessmentScheme',
            flex: 0.2,
			hidden: true,
            renderer: function (v) { return v; }
        },
        {
            text: getExaminationTranslation('COURSE'),
            dataIndex: 'courseCode',
            flex: 0.25,
			hidden: true,
            renderer: function (v) { return v; }
        },
        {
            text: getExaminationTranslation('AMOUNT'),
            dataIndex: 'amount',
            align: 'right',
            flex: 0.15,
			renderer: function(value, meta, record) {
				return record.get('feePlanId') == null ? '' : value;
			}
        },
        {
            text: getExaminationTranslation('LATE_FEE'),
            dataIndex: 'lateFee',
            align: 'right',
            flex: 0.15,
			renderer: function(value, meta, record) {
				return record.get('feePlanId') == null ? '' : value;
			}
        },
        {
            text: getExaminationTranslation('TOTAL_AMOUNT'),
            dataIndex: 'totalAmount',
            align: 'right',
            flex: 0.15,
			renderer: function(value, meta, record) {
				return record.get('feePlanId') == null ? '' : value;
			}
        },
        {
            text: getExaminationTranslation('APPLICATION_STATUS'),
            dataIndex: 'applicationStatus',
            flex: 0.15,
            renderer: function (v) { return v; }
        },
        {
            text: getExaminationTranslation('HALL_TICKET_NO'),
            dataIndex: 'hallticket',
            flex: 0.15,
            sortable: true,
            renderer: function (value) {
                return value ? "<a href=#>" + value + "</a>" : "";
            }
        },
        {
            text: getExaminationTranslation('HALL_TICKET_PUBLISH'),
            dataIndex: 'isPublishHallTicket',
            flex: 0.15,
            renderer: function (value, meta, record) {
                if (!isNullOrEmpty(record.data.financeHoldStatus) &&
                    record.data.financeHoldStatus === "Hold") {

                    return "<span style='color:red'>Hold for Student</span>";

                } else if (record.data.isPublishHallTicket) {
                    return "<span>Published</span>";
                } else {
                    return "<span style='color:red'>Pending</span>";
                }
            }
        }
    ],

    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            displayInfo: true,
			store: 'RegEGStores.RegEGApplicationStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE')
        }]
    }]
});