/**
 * @author Vinay Kumrawat
 */
Ext.define('Academia.view.examinationattendancerule.AttendanceRangeGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.attendancerangegrid',
    title: getExaminationTranslation('ATTENDANCE_RANGE'),
    store:'attendancerulestores.AttendanceRangeGridStore',
    border: true,
    autoScroll: false,
    cls: 'limitedColumnGrid',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
   tbar: [{
       xtype: 'button',
       itemId: 'btnAdd_cr',
       tooltip: getCommonTranslation('ADD'),
       glyph: ICONGLYPH.ADDGLYPH,
       disabled: true
   }, {
       xtype: 'button',
       itemId: 'btnEdit_cr',
       tooltip: getCommonTranslation('EDIT'),
       glyph: ICONGLYPH.EDITGLYPH,
       disabled: true
   }, {
       xtype: 'button',
       itemId: 'btnDelete_cr',
       tooltip: getCommonTranslation('DELETE'),
       glyph: ICONGLYPH.DELETEGLYPH,
       disabled: true
   }],
    columns: [{
        header: getCommonTranslation('MARKS'),
        dataIndex: 'marks',
        flex:1
    },{
        header: getExaminationTranslation('ATTENDANCE_RANGE_FROM'),
        dataIndex: 'rangeFrom',
        flex:1
    }, {
        header: getExaminationTranslation('ATTENDANCE_RANGE_TO'),
        dataIndex: 'rangeTo',
        flex:1
   }],
    initComponent: function() {
        var this$ = this;
        Ext.apply(this$, {
            store: 'attendancerulestores.AttendanceRangeGridStore',
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                   store: 'attendancerulestores.AttendanceRangeGridStore',
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    }
});