/**
 * Abhishek Chouhan
 */
var calculateAverageGrid =Ext.create('Academia.store.examinationcenters.calculateAverage.CalculateAverageGridStore');
Ext.define('Academia.view.examinationcenters.calculateAverage.CalculateAverageGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.calculateaveragegrid',
	store: calculateAverageGrid,
	border: true,
	frame:false,
	selType:'checkboxmodel',
	title:getExaminationTranslation('LIST_OF_STUDENTS'),
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		showHeaderCheckbox: true,
		checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
		allowDeselect: false,
		//injectCheckbox:1
	},
	/*dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
				xtype: 'custompagingtoolbar',
				itemId:'managePaggingToolBarItemId',
				plugins:['pagesize'],
			    store : calculateAverageGrid,
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
		}]
	}],*/
	isGridConfigurable:true,
	enableColumnHide: false,
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		text:getExaminationTranslation('CALCULATE_AVERAGE'),
		itemId:'caclulateAverageButtonId',
		scale: CONSTANTS.BUTTONSIZE,
		tooltip: getExaminationTranslation('CALCULATE_AVERAGE')
	},{
		xtype: 'button',
		text:getExaminationTranslation('DELETE'),
		itemId:'DeleteButtonId',
		scale: CONSTANTS.BUTTONSIZE,
		tooltip: getExaminationTranslation('DELETE'),
		disabled:true
	},{
		xtype: 'button',
		text:getExaminationTranslation('CONDONE_SUBJECTS'),
		itemId:'condoneSubjectButtonId',
		scale: CONSTANTS.BUTTONSIZE,
		tooltip: getExaminationTranslation('CONDONE_SUBJECTS'),
		disabled:true,
		hidden:true
	},{
		xtype: 'button',
		text:getExaminationTranslation('CALCULATE_RANK'),
		itemId:'calculateRankButtonId',
		scale: CONSTANTS.BUTTONSIZE,
		tooltip: getExaminationTranslation('CALCULATE_RANK'),
		disabled:true,
		hidden:true
	}],

	columns: [{
		header: getCommonTranslation('ADMISSION_ID'),
		dataIndex: 'admissionCode',
		flex:.4,
		sortable:true
	},{
		header: getCommonTranslation('STUDENT_ID'),
		dataIndex: 'studentCode',
		flex:.4,
		sortable:true
	},{
		header: getCommonTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.4,
		sortable:true
	},{
		header: getCommonTranslation('STUDENT_NAME'),
		dataIndex: 'studentName',
		flex:.3,
		sortable: true
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex:.3,
		sortable: true,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex:.3,
		sortable: true,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex:.3,
		sortable: true
	},{
		header: getCommonTranslation('AVERAGE_MARKS'),
		dataIndex: 'marks',
		flex:.3,
		sortable: true,
		renderer:function(val,rec,e){
			if(!isNullOrEmpty(val)){
				if(val=='0' || val == '0.00' || val == '0.0'){
					return val;
				}else{
					return "<a href='#'>"+val.toFixed(2)+"</a>" ;
				}
			} else {
				return "-";
			}
		}
	},{
		header: getCommonTranslation('AVERAGE_GRADE'),
		dataIndex: 'grade',
		flex:.3,
		hidden:true,
		sortable: true
	},{
		header: getCommonTranslation('PROMOTION_STATUS'),
		dataIndex: 'promotionStatus',
		flex:.3,
		hidden:true
	},{
		header:getCommonTranslation('WHETHER_CONDONED'),
		dataIndex: 'revisedPromotionStatus',
		flex:.3,
		hidden:true,
		renderer:function(val,rec,e){
			if(!isNullOrEmpty(val)){
				if(val==="CONDONED_SUBJECT_PASS"){
					return "Yes";
				}else{
					return "No" ;
				}
			} else {
				return "No" ;
			}
		}
	},{
		header: getCommonTranslation('RANK'),
		dataIndex: 'marksRank',
		flex:.3,
		hidden:true
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1
		/*listeners: {
			beforeedit: function(editor , context){
			}
		  } */
	}]
});
