/**
 * @author deepika Paramr
 */
Ext.define('Academia.view.examinationcenters.evalresultlisting.EvalGenerateReportWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.evalgeneratereportwin',
	title : getExaminationTranslation('GENERATE_REPORT'),
	modal: true,
	autoScroll:true,
	maxHeight:250,
	layout: 'fit',
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: '0 0 8 0',
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top'
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
        		width: 226
			},
			items: [{
            	xtype: 'customcombobox',
            	itemId:'reportTypeCombo',
        		name: 'reportTypeCombo',
        	    store:'setup.templatemapping.TemplateNameForFoilsReportStore',//'examinationcenters.marksheet.MarksheetGenerationTemplate',
        		displayField:'code',
        		valueField:'id',
        		forceSelection:true,
        		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        		enableKeyEvents  : 'true',
        		typeAhead:true,
        		minChars:3,
        		listConfig: {
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				},
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				}
    			},
        		allowBlank:false,
        		fieldLabel:getCommonTranslation('REPORT_TYPE')
            }]
		},{
			xtype: 'fieldcontainer',    
			layout : {
				type : 'hbox'
			},
			width:'auto',
			items : [{
				xtype : 'button',
				text : getCommonTranslation("GENERATE"),
				itemId : 'generateReportBtn',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}]
		}]
	}]
});