/**
 * @author Manas Luktuke     
 */
Ext.define('Academia.view.examinationcenters.evalresultlisting.EvaluationSubTypeLevelGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.evaluationsubtypelevelgrid',  
    store: 'examinationcenters.evalresultlisting.EvaluationSubTypeLevelStore', 
    title: getCommonTranslation('ASSESSMENT_SUB_TYPE'),     
    border: true,
    isGridConfigurable: true,
	enableColumnHide: false,    
    refreshStoreData: true,
    deferEmptyText: false,
    cls: 'grid-bottom-border',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    }, 
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        itemId: 'dockedItemsItemId',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'examinationcenters.evalresultlisting.EvaluationSubTypeLevelStore',      
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [{
    	xtype: 'button',
    	itemId: 'approveButtonItemId',
    	text: getCommonTranslation('APPROVE'),
    	tooltip :getCommonTranslation('APPROVE'),
    	hidden: true 
    }],
    columns: [{ 
			        header: getCommonTranslation('EVALUATION_PLAN_LEVEL_TWO_ID'),   
			        dataIndex: 'id',
			        flex: 1,
			        hidden: true     
			    },
			    {
			        header: getCommonTranslation('ASSESSMENT_SUB_TYPE'),
			        dataIndex: 'levelName',
			        flex: 1,
			        hidden: false
			    },
                {
                    header: getCommonTranslation('WEIGHTAGE'),
                    dataIndex: 'weightage',
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('MAX_MARKS'),
                    dataIndex: 'marksObtainedFrom',
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('MAX_GRADE'),
                    dataIndex: 'gradeObtainedFrom', 
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('OBTAINED_MARKS'),
                    dataIndex: 'obtainedMarks',
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('EFFECTIVE_MARKS'),
                    dataIndex: 'effectiveMarks',
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('GRADE_OBTAINED'),
                    dataIndex: 'grade',
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('GRADE_POINT'),
                    dataIndex: 'gradePoint', 
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('SECTION_WISE_RANK'),
                    dataIndex: 'sectionRank', 
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('TYPE_LEVEL_RANK'),
                    dataIndex: 'courseRank',  
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('STATUS'),
                    dataIndex: 'status',
                    flex: 1,
                    hidden: false,
			        renderer:function(value){
						if(!isNullOrEmpty(value)) {
							return value;  
						}                        
					}
                },
                {
                    header: getCommonTranslation('COURSE_VARIANT_ID'),
                    dataIndex: 'courseVariantId', 
                    flex: 1,
                    hidden: true
                },
                {
                    header: getCommonTranslation('SECTION_ID'),
                    dataIndex: 'sectionId',    
                    flex: 1,
                    hidden: true
                }  
            ]
}); 